/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import org.simmetrics.StringDistance;
import org.simmetrics.builders.StringDistanceBuilder;
import org.simmetrics.metrics.BlockDistance;
import org.simmetrics.metrics.CosineSimilarity;
import org.simmetrics.metrics.DamerauLevenshtein;
import org.simmetrics.metrics.Dice;
import org.simmetrics.metrics.EuclideanDistance;
import org.simmetrics.metrics.GeneralizedJaccard;
import org.simmetrics.metrics.HammingDistance;
import org.simmetrics.metrics.Identity;
import org.simmetrics.metrics.Jaccard;
import org.simmetrics.metrics.Jaro;
import org.simmetrics.metrics.JaroWinkler;
import org.simmetrics.metrics.Levenshtein;
import org.simmetrics.metrics.LongestCommonSubsequence;
import org.simmetrics.metrics.LongestCommonSubstring;
import org.simmetrics.metrics.OverlapCoefficient;
import org.simmetrics.metrics.SimonWhite;
import org.simmetrics.tokenizers.Tokenizers;

public final class StringDistances {
    public static StringDistance cosineSimilarity() {
        return StringDistanceBuilder.with(new CosineSimilarity<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringDistance blockDistance() {
        return StringDistanceBuilder.with(new BlockDistance<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringDistance damerauLevenshtein() {
        return new DamerauLevenshtein();
    }

    public static StringDistance dice() {
        return StringDistanceBuilder.with(new Dice<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringDistance euclideanDistance() {
        return StringDistanceBuilder.with(new EuclideanDistance<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringDistance generalizedJaccard() {
        return StringDistanceBuilder.with(new GeneralizedJaccard<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringDistance identity() {
        return new StringDistance(){
            private final Identity<String> metric = new Identity();

            @Override
            public float distance(String a, String b) {
                return this.metric.distance(a, b);
            }

            public String toString() {
                return this.metric.toString();
            }
        };
    }

    public static StringDistance jaccard() {
        return StringDistanceBuilder.with(new Jaccard<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringDistance jaro() {
        return new Jaro();
    }

    public static StringDistance jaroWinkler() {
        return new JaroWinkler();
    }

    public static StringDistance levenshtein() {
        return new Levenshtein();
    }

    public static StringDistance overlapCoefficient() {
        return StringDistanceBuilder.with(new OverlapCoefficient<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringDistance qGramsDistance() {
        return StringDistanceBuilder.with(new BlockDistance<String>()).tokenize(Tokenizers.qGramWithPadding(3)).build();
    }

    public static StringDistance simonWhite() {
        return StringDistanceBuilder.with(new SimonWhite<String>()).tokenize(Tokenizers.whitespace()).tokenize(Tokenizers.qGram(2)).build();
    }

    public static StringDistance hammingDistance() {
        return HammingDistance.forString();
    }

    public static StringDistance longestCommonSubsequence() {
        return new LongestCommonSubsequence();
    }

    public static StringDistance longestCommonSubstring() {
        return new LongestCommonSubstring();
    }
}

