/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.registry.SFMTextEditors;
import ca.teamdman.sfm.client.screen.ExamplesScreen;
import ca.teamdman.sfm.client.screen.LabelGunScreen;
import ca.teamdman.sfm.client.screen.LogsScreen;
import ca.teamdman.sfm.client.screen.TomlEditScreen;
import ca.teamdman.sfm.client.screen.TomlEditScreenOpenContext;
import ca.teamdman.sfm.client.screen.text_editor.SFMTextEditScreenV1;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditScreenOpenContext;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditorRegistration;
import ca.teamdman.sfm.client.text_editor.SFMTextEditScreenDiskOpenContext;
import ca.teamdman.sfm.client.text_editor.SFMTextEditScreenExampleProgramOpenContext;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import java.io.BufferedReader;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SFMScreenChangeHelpers {
    public static void setOrPushScreen(Screen screen) {
        if (Minecraft.getInstance().screen == null) {
            Minecraft.getInstance().setScreen(screen);
        } else {
            Minecraft.getInstance().pushGuiLayer(screen);
        }
    }

    public static void popScreen() {
        Minecraft.getInstance().popGuiLayer();
    }

    public static void showLabelGunScreen(ItemStack stack, InteractionHand hand) {
        SFMScreenChangeHelpers.setOrPushScreen(new LabelGunScreen(stack, hand));
    }

    public static void showProgramEditScreen(ISFMTextEditScreenOpenContext context) {
        String preferredEditorId = (String)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.preferredEditor.get();
        ISFMTextEditorRegistration textEditorRegistration = Objects.requireNonNullElse((ISFMTextEditorRegistration)SFMTextEditors.registry().get(new ResourceLocation(preferredEditorId)), (ISFMTextEditorRegistration)SFMTextEditors.V1.get());
        textEditorRegistration.openScreen(context);
    }

    public static void showTomlEditScreen(TomlEditScreenOpenContext context) {
        TomlEditScreen screen = new TomlEditScreen(context);
        SFMScreenChangeHelpers.setOrPushScreen(screen);
        screen.scrollToTop();
    }

    public static void showProgramEditScreen(String initialContent) {
        SFMTextEditScreenDiskOpenContext openContext = new SFMTextEditScreenDiskOpenContext(initialContent, LabelPositionHolder.empty(), x -> {});
        SFMScreenChangeHelpers.showProgramEditScreen(openContext);
    }

    public static void showExampleListScreen(String diskProgramString, LabelPositionHolder labelPositionHolder, Consumer<String> saveCallback) {
        SFMScreenChangeHelpers.setOrPushScreen(new ExamplesScreen((chosenExample, templates) -> {
            SFMTextEditScreenV1 screen = new SFMTextEditScreenV1(new SFMTextEditScreenExampleProgramOpenContext((String)chosenExample, diskProgramString, (Map<String, String>)templates, labelPositionHolder, saveCallback));
            SFMScreenChangeHelpers.setOrPushScreen(screen);
            screen.scrollToTop();
        }));
    }

    public static void showLogsScreen(ManagerContainerMenu menu) {
        LogsScreen screen = new LogsScreen(menu);
        SFMScreenChangeHelpers.setOrPushScreen(screen);
        screen.scrollToBottom();
        SFMPackets.sendToServer(new ServerboundManagerLogDesireUpdatePacket(menu.containerId, menu.MANAGER_POSITION, true));
    }

    public static void showItemInspectorScreen(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag != null) {
            String content = tag.toString();
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.keyboardHandler.setClipboard(content);
            SFM.LOGGER.info("Copied {} characters to clipboard", (Object)content.length());
            assert (minecraft.player != null);
            minecraft.player.sendSystemMessage((Component)LocalizationKeys.ITEM_INSPECTOR_COPIED_TO_CLIPBOARD.getComponent(Component.literal((String)String.valueOf(content.length())).withStyle(ChatFormatting.AQUA)));
        }
    }

    public static void showChangelog() {
        String changelog = null;
        ResourceManager irm = Minecraft.getInstance().getResourceManager();
        Map found = irm.listResources("template_programs", path -> path.getPath().endsWith(".sfml") || path.getPath().endsWith(".sfm"));
        for (Map.Entry entry : found.entrySet()) {
            if (!((ResourceLocation)entry.getKey()).getPath().equals("template_programs/changelog.sfml")) continue;
            try (BufferedReader reader = ((Resource)entry.getValue()).openAsReader();){
                changelog = reader.lines().collect(Collectors.joining("\n"));
                break;
            }
            catch (Exception e) {
                SFM.LOGGER.error("Failed to read changelog", (Throwable)e);
            }
        }
        if (changelog == null) {
            SFM.LOGGER.error("Failed to find changelog");
            return;
        }
        SFMTextEditScreenV1 screen = new SFMTextEditScreenV1(new SFMTextEditScreenExampleProgramOpenContext(changelog, changelog, Map.of("changelog.sfml", changelog), LabelPositionHolder.empty(), newContent -> {}));
        SFMScreenChangeHelpers.setOrPushScreen(screen);
        screen.scrollToTop();
    }

    @Nullable
    public static Screen getCurrentScreen() {
        return Minecraft.getInstance().screen;
    }

    public static void setScreen(@Nullable Screen screen) {
        Minecraft.getInstance().setScreen(screen);
    }
}

