/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public record ServerboundManagerRebuildPacket(int windowId, BlockPos pos) implements SFMPacket
{

    public static class Daddy
    implements SFMPacketDaddy<ServerboundManagerRebuildPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundManagerRebuildPacket msg, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeVarInt(msg.windowId());
            friendlyByteBuf.writeBlockPos(msg.pos());
        }

        @Override
        public ServerboundManagerRebuildPacket decode(FriendlyByteBuf friendlyByteBuf) {
            return new ServerboundManagerRebuildPacket(friendlyByteBuf.readVarInt(), friendlyByteBuf.readBlockPos());
        }

        @Override
        public void handle(ServerboundManagerRebuildPacket msg, SFMPacketHandlingContext context) {
            context.handleServerboundContainerPacket(ManagerContainerMenu.class, ManagerBlockEntity.class, msg.pos, msg.windowId, (menu, manager) -> {
                ServerPlayer player = context.sender();
                if (player == null) {
                    SFM.LOGGER.error("Received {} from null player", (Object)this.getPacketClass().getName());
                    return;
                }
                CableNetworkManager.purgeCableNetworkForManager(manager);
                manager.logger.warn(x -> x.accept(LocalizationKeys.LOG_MANAGER_CABLE_NETWORK_REBUILD.get()));
                SFM.LOGGER.debug("{} performed rebuild for manager {} {}", (Object)player.getName().getString(), (Object)msg.pos(), (Object)manager.getLevel());
            });
        }

        @Override
        public Class<ServerboundManagerRebuildPacket> getPacketClass() {
            return ServerboundManagerRebuildPacket.class;
        }
    }
}

