/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import ca.teamdman.sfml.ast.DirectionQualifier;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.apache.commons.lang3.mutable.MutableBoolean;

public record ServerboundNetworkToolUsePacket(BlockPos blockPosition, Direction blockFace) implements SFMPacket
{

    public static class Daddy
    implements SFMPacketDaddy<ServerboundNetworkToolUsePacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundNetworkToolUsePacket msg, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeBlockPos(msg.blockPosition);
            friendlyByteBuf.writeEnum((Enum)msg.blockFace);
        }

        @Override
        public ServerboundNetworkToolUsePacket decode(FriendlyByteBuf friendlyByteBuf) {
            return new ServerboundNetworkToolUsePacket(friendlyByteBuf.readBlockPos(), (Direction)friendlyByteBuf.readEnum(Direction.class));
        }

        @Override
        public void handle(ServerboundNetworkToolUsePacket msg, SFMPacketHandlingContext context) {
            int i;
            BlockPos pos;
            ServerPlayer player = context.sender();
            if (player == null) {
                return;
            }
            Level level = player.level();
            if (!level.isLoaded(pos = msg.blockPosition())) {
                return;
            }
            StringBuilder payload = new StringBuilder().append("---- block position ----\n").append(pos).append("\n---- block state ----\n");
            BlockState state = level.getBlockState(pos);
            payload.append(state).append("\n");
            ArrayList foundNetworks = new ArrayList();
            for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                BlockPos cablePosition = pos.relative(direction);
                CableNetworkManager.getOrRegisterNetworkFromCablePosition(level, cablePosition).ifPresent(foundNetworks::add);
            }
            payload.append("---- cable networks ----\n");
            if (foundNetworks.isEmpty()) {
                payload.append("No networks found\n");
            } else {
                for (CableNetwork network : foundNetworks) {
                    payload.append(network).append("\n");
                }
            }
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity != null) {
                if (SFMEnvironmentUtils.isInIDE()) {
                    payload.append("---- (dev only) block entity ----\n");
                    payload.append(entity).append("\n");
                }
                payload.append("---- capability directions ----\n");
                for (BlockCapability cap : SFMResourceTypes.getCapabilities()::iterator) {
                    String directions = DirectionQualifier.EVERY_DIRECTION.stream().filter(dir -> level.getCapability(cap, pos, dir) != null).map(dir -> dir == null ? "NULL DIRECTION" : DirectionQualifier.directionToString(dir)).collect(Collectors.joining(", ", "[", "]"));
                    if (directions.equals("[]")) continue;
                    payload.append(cap.name()).append("\n").append(directions).append("\n");
                }
            }
            Direction[] directions = new Direction[SFMDirections.DIRECTIONS_WITHOUT_NULL.length + 1];
            directions[0] = msg.blockFace;
            directions[1] = null;
            int assignmentIndex = 2;
            for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                if (direction == msg.blockFace) continue;
                directions[assignmentIndex++] = direction;
            }
            String[] messages = new String[directions.length];
            messages[0] = String.format("---- exports for selected face: %s ----", msg.blockFace);
            for (i = 1; i < directions.length; ++i) {
                messages[i] = String.format("---- exports for face: %s ----", directions[i]);
            }
            for (i = 0; i < directions.length; ++i) {
                int index = i;
                payload.append(messages[i]).append("\n");
                MutableBoolean foundExports = new MutableBoolean(false);
                SFMResourceTypes.registry().entrySet().stream().map(entry -> ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults((ResourceKey)entry.getKey(), (ResourceType)entry.getValue(), level, pos, directions[index])).filter(s -> !s.isBlank()).forEach(results -> {
                    foundExports.setTrue();
                    payload.append((String)results).append("\n");
                });
                if (foundExports.isFalse()) {
                    payload.append("No exports found");
                }
                payload.append("\n");
            }
            if (entity != null && player.hasPermissions(2)) {
                payload.append("---- (op only) nbt data ----\n");
                payload.append(entity.serializeNBT()).append("\n");
            }
            SFMPackets.sendToPlayer(() -> player, (Object)new ClientboundInputInspectionResultsPacket(SFMPacketDaddy.truncate(payload.toString(), 20480)));
        }

        @Override
        public Class<ServerboundNetworkToolUsePacket> getPacketClass() {
            return ServerboundNetworkToolUsePacket.class;
        }
    }
}

