/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.Math;
import org.simmetrics.metrics.functions.AffineGap;
import org.simmetrics.metrics.functions.Gap;
import org.simmetrics.metrics.functions.MatchMismatch;
import org.simmetrics.metrics.functions.Substitution;

public final class SmithWaterman
implements StringMetric {
    private final Gap gap;
    private final Substitution substitution;
    private final int windowSize;

    public SmithWaterman() {
        this(new AffineGap(-5.0f, -1.0f), new MatchMismatch(5.0f, -3.0f), Integer.MAX_VALUE);
    }

    public SmithWaterman(Gap gap, Substitution substitution, int windowSize) {
        Preconditions.checkNotNull((Object)gap);
        Preconditions.checkNotNull((Object)substitution);
        Preconditions.checkArgument((windowSize >= 0 ? 1 : 0) != 0);
        this.gap = gap;
        this.substitution = substitution;
        this.windowSize = windowSize;
    }

    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        float maxDistance = (float)java.lang.Math.min(a.length(), b.length()) * java.lang.Math.max(this.substitution.max(), this.gap.min());
        return this.smithWaterman(a, b) / maxDistance;
    }

    private float smithWaterman(String a, String b) {
        int k;
        float maxGapCost;
        int i;
        int n = a.length();
        int m = b.length();
        float[][] d = new float[n][m];
        float f = java.lang.Math.max(0.0f, this.substitution.compare(a, 0, b, 0));
        d[0][0] = f;
        float max = f;
        for (i = 0; i < n; ++i) {
            maxGapCost = 0.0f;
            for (k = java.lang.Math.max(1, i - this.windowSize); k < i; ++k) {
                maxGapCost = java.lang.Math.max(maxGapCost, d[i - k][0] + this.gap.value(i - k, i));
            }
            d[i][0] = Math.max(0.0f, maxGapCost, this.substitution.compare(a, i, b, 0));
            max = java.lang.Math.max(max, d[i][0]);
        }
        for (int j = 1; j < m; ++j) {
            maxGapCost = 0.0f;
            for (k = java.lang.Math.max(1, j - this.windowSize); k < j; ++k) {
                maxGapCost = java.lang.Math.max(maxGapCost, d[0][j - k] + this.gap.value(j - k, j));
            }
            d[0][j] = Math.max(0.0f, maxGapCost, this.substitution.compare(a, 0, b, j));
            max = java.lang.Math.max(max, d[0][j]);
        }
        for (i = 1; i < n; ++i) {
            for (int j = 1; j < m; ++j) {
                int k2;
                float maxGapCost2 = 0.0f;
                for (k2 = java.lang.Math.max(1, i - this.windowSize); k2 < i; ++k2) {
                    maxGapCost2 = java.lang.Math.max(maxGapCost2, d[i - k2][j] + this.gap.value(i - k2, i));
                }
                for (k2 = java.lang.Math.max(1, j - this.windowSize); k2 < j; ++k2) {
                    maxGapCost2 = java.lang.Math.max(maxGapCost2, d[i][j - k2] + this.gap.value(j - k2, j));
                }
                d[i][j] = Math.max(0.0f, maxGapCost2, d[i - 1][j - 1] + this.substitution.compare(a, i, b, j));
                max = java.lang.Math.max(max, d[i][j]);
            }
        }
        return max;
    }

    public String toString() {
        return "SmithWaterman [gap=" + this.gap + ", substitution=" + this.substitution + ", windowSize=" + this.windowSize + "]";
    }
}

