/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.export;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.jei.SFMJEIPlugin;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.library.ingredients.IIngredientSupplier;
import mezz.jei.library.util.IngredientSupplierHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ClientExportHelper {
    private static final Object registryReaderLock = new Object();

    public static Collection<ItemStack> gatherItems() {
        assert (Minecraft.m_91087_().f_91074_ != null);
        assert (Minecraft.m_91087_().f_91073_ != null);
        CreativeModeTabs.m_269226_((FeatureFlagSet)Minecraft.m_91087_().f_91074_.f_108617_.m_247016_(), (boolean)true, (HolderLookup.Provider)Minecraft.m_91087_().f_91073_.m_9598_());
        return CreativeModeTabs.m_258007_().m_260957_();
    }

    public static void dumpItems(@Nullable Player player) throws IOException {
        JsonArray jsonArray = new JsonArray();
        Collection<ItemStack> items = ClientExportHelper.gatherItems();
        for (ItemStack stack : items) {
            JsonObject jsonObject = new JsonObject();
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            assert (id != null);
            jsonObject.addProperty("id", id.toString());
            if (stack.getShareTag() != null) {
                jsonObject.addProperty("data", stack.getShareTag().toString());
            }
            JsonArray tags = new JsonArray();
            SFMResourceTypes.ITEM.get().getTagsForStack(stack).map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)tags).add(arg_0));
            jsonObject.add("tags", (JsonElement)tags);
            String tooltip = stack.m_41651_(player, (TooltipFlag)TooltipFlag.f_256730_).stream().map(Component::getString).reduce((line1, line2) -> line1 + "\n" + line2).orElse("");
            jsonObject.addProperty("tooltip", tooltip);
            jsonArray.add((JsonElement)jsonObject);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String content = gson.toJson((JsonElement)jsonArray);
        Path gameDir = FMLPaths.GAMEDIR.get();
        Path folder = Paths.get(gameDir.toString(), "sfm");
        Files.createDirectories(folder, new FileAttribute[0]);
        File itemFile = new File(folder.toFile(), "items.json");
        try (FileOutputStream str = new FileOutputStream(itemFile);){
            str.write(content.getBytes(StandardCharsets.UTF_8));
        }
        SFM.LOGGER.info("Exported item data to {}", (Object)itemFile);
        assert (Minecraft.m_91087_().f_91074_ != null);
        Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)String.format("Exported %d items to \"%s\"", items.size(), itemFile.getAbsolutePath())));
    }

    public static void dumpJei(Player player, boolean includeHidden) throws IOException {
        IJeiRuntime jeiRuntime = SFMJEIPlugin.getJeiRuntime();
        if (jeiRuntime == null) {
            String msg = "No JEI runtime detected, no recipes have been exported";
            SFM.LOGGER.error(msg);
            player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
            return;
        }
        IJeiHelpers jeiHelpers = jeiRuntime.getJeiHelpers();
        IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
        IRecipeManager recipeManager = jeiRuntime.getRecipeManager();
        Stream recipeCategoryStream = recipeManager.createRecipeCategoryLookup().includeHidden().get();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ArrayList resourceTypes = new ArrayList();
        SFMResourceTypes.registry().stream().forEach(resourceTypes::add);
        Path gameDir = FMLPaths.GAMEDIR.get();
        Path folder = Paths.get(gameDir.toString(), "sfm", "jei");
        try {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            SFM.LOGGER.error("Failed to create directories: {}", (Object)folder.toString(), (Object)e);
            player.m_213846_((Component)Component.m_237113_((String)"Failed to create directories for saving recipes.").m_130940_(ChatFormatting.RED));
            return;
        }
        ((Stream)recipeCategoryStream.parallel()).forEach(recipeCategory -> {
            ConcurrentLinkedDeque<JsonObject> recipeResults = new ConcurrentLinkedDeque<JsonObject>();
            AtomicInteger counter = new AtomicInteger();
            AtomicInteger fileIndex = new AtomicInteger();
            ClientExportHelper.extractCategory(gson, jeiHelpers, recipeCategory, recipeManager, ingredientManager, recipeResults, resourceTypes, includeHidden, player, counter, fileIndex, folder);
            if (!recipeResults.isEmpty()) {
                ClientExportHelper.writeChunkToFile(gson, recipeResults, recipeCategory, fileIndex.getAndIncrement(), folder, player);
            }
            player.m_213846_((Component)Component.m_237113_((String)String.format("Completed exporting all JEI entries for category \"%s\"", recipeCategory.getTitle().getString())));
        });
    }

    private static <T> void extractCategory(Gson gson, IJeiHelpers jeiHelpers, IRecipeCategory<T> recipeCategory, IRecipeManager recipeManager, IIngredientManager ingredientManager, ConcurrentLinkedDeque<JsonObject> recipeResults, Collection<ResourceType<?, ?, ?>> resourceTypes, boolean includeHidden, Player player, AtomicInteger counter, AtomicInteger fileIndex, Path folder) {
        String categoryString = recipeCategory.toString();
        String categoryTitle = recipeCategory.getTitle().getString();
        RecipeType recipeType = recipeCategory.getRecipeType();
        IRecipeLookup recipeLookup = recipeManager.createRecipeLookup(recipeType);
        if (includeHidden) {
            recipeLookup = recipeLookup.includeHidden();
        }
        Stream recipes = recipeLookup.get();
        ((Stream)recipes.parallel()).forEach(recipe -> {
            IIngredientSupplier ingredientSupplier = IngredientSupplierHelper.getIngredientSupplier((Object)recipe, (IRecipeCategory)recipeCategory, (IIngredientManager)ingredientManager);
            if (ingredientSupplier == null) {
                player.m_213846_((Component)Component.m_237113_((String)"Could not get ingredient supplier for recipe from category ").m_130940_(ChatFormatting.RED).m_7220_(recipeCategory.getTitle()).m_7220_((Component)Component.m_237113_((String)" with recipe object ")).m_7220_((Component)Component.m_237113_((String)recipe.toString())));
                return;
            }
            ConcurrentLinkedDeque<JsonObject> ingredientResults = new ConcurrentLinkedDeque<JsonObject>();
            JsonArray ingredientArray = new JsonArray();
            for (RecipeIngredientRole recipeIngredientRole : RecipeIngredientRole.values()) {
                ((Stream)ingredientSupplier.getIngredients(recipeIngredientRole).stream().parallel()).forEachOrdered(typedIngredient -> {
                    JsonObject ingredientObject = new JsonObject();
                    ingredientObject.addProperty("role", recipeIngredientRole.toString());
                    ingredientObject.addProperty("ingredientType", typedIngredient.getType().getIngredientClass().getName());
                    Object ingredient = typedIngredient.getIngredient();
                    for (ResourceType resourceType : resourceTypes) {
                        if (!resourceType.matchesStackType(ingredient)) continue;
                        ClientExportHelper.addIngredientInfo(resourceType, ingredient, ingredientObject);
                    }
                    ingredientObject.addProperty("ingredient", ingredient.toString());
                    ingredientResults.add(ingredientObject);
                });
            }
            ingredientResults.forEach(arg_0 -> ((JsonArray)ingredientArray).add(arg_0));
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("category", categoryString);
            jsonObject.addProperty("categoryTitle", categoryTitle);
            jsonObject.addProperty("recipeTypeId", recipeType.getUid().toString());
            jsonObject.addProperty("recipeClass", recipeType.getRecipeClass().toString());
            jsonObject.addProperty("recipeObject", recipe.toString());
            jsonObject.add("ingredients", (JsonElement)ingredientArray);
            recipeResults.add(jsonObject);
            int count = counter.incrementAndGet();
            if (count % 1000 == 0) {
                ClientExportHelper.writeChunkToFile(gson, recipeResults, recipeCategory, fileIndex.getAndIncrement(), folder, player);
                recipeResults.clear();
            }
            if (count > 0 && count % 1000 == 0) {
                player.m_213846_((Component)Component.m_237113_((String)String.format("Processed %d recipes so far for category \"%s\"", count, categoryTitle)));
            }
        });
    }

    private static void writeChunkToFile(Gson gson, ConcurrentLinkedDeque<JsonObject> recipeResults, IRecipeCategory<?> recipeCategory, int chunkIndex, Path folder, Player player) {
        String fileName = recipeCategory.getTitle().getString().replaceAll("[<>:\"/\\\\|?*]", "-") + "-" + chunkIndex + ".json";
        File file = new File(folder.toFile(), fileName);
        JsonArray jsonArray = new JsonArray();
        recipeResults.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        String content = gson.toJson((JsonElement)jsonArray);
        try (FileOutputStream str = new FileOutputStream(file);){
            str.write(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            SFM.LOGGER.error("Failed to write JEI category data for category: {}", (Object)recipeCategory.getTitle().getString(), (Object)e);
            player.m_213846_((Component)Component.m_237113_((String)"Failed to save recipe category chunk: ").m_7220_(recipeCategory.getTitle()).m_130940_(ChatFormatting.RED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <STACK, ITEM, CAP> void addIngredientInfo(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, JsonObject ingredientObject) {
        ResourceLocation stackRegistryKey;
        long amount = resourceType.getAmount(stack);
        ingredientObject.addProperty("ingredientAmount", (Number)amount);
        Object object = registryReaderLock;
        synchronized (object) {
            stackRegistryKey = resourceType.getRegistryKeyForStack(stack);
        }
        ingredientObject.addProperty("ingredientId", stackRegistryKey.toString());
        JsonArray tags = new JsonArray();
        resourceType.getTagsForStack(stack).map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)tags).add(arg_0));
        ingredientObject.add("tags", (JsonElement)tags);
    }
}

