/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.client.screen.LogsScreenMultiLineEditBox;
import ca.teamdman.sfm.client.screen.LogsTextStylingHelper;
import ca.teamdman.sfm.client.screen.SFMWidgetUtils;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.diagnostics.SFMDiagnostics;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.net.ServerboundManagerClearLogsPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.net.ServerboundManagerSetLogLevelPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.timing.SFMEpochInstant;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.Level;

public class LogsScreen
extends Screen {
    private final ManagerContainerMenu MENU;
    private LogsScreenMultiLineEditBox textarea;
    private int lastSize = 0;
    private Map<Level, Button> levelButtons = new HashMap<Level, Button>();
    private String lastKnownLogLevel;

    public LogsScreen(ManagerContainerMenu menu) {
        super((Component)LocalizationKeys.LOGS_SCREEN_TITLE.getComponent());
        this.MENU = menu;
        this.lastKnownLogLevel = this.MENU.logLevel;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player == null || player.m_5833_();
    }

    public void onLogLevelChange() {
        for (Map.Entry<Level, Button> entry : this.levelButtons.entrySet()) {
            Level level = entry.getKey();
            Button button = entry.getValue();
            button.f_93623_ = !this.MENU.logLevel.equals(level.name());
        }
        this.lastKnownLogLevel = this.MENU.logLevel;
    }

    public void m_7379_() {
        SFMPackets.sendToServer(new ServerboundManagerLogDesireUpdatePacket(this.MENU.f_38840_, this.MENU.MANAGER_POSITION, false));
        super.m_7379_();
    }

    public void scrollToBottom() {
        this.textarea.scrollToBottom();
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String prev = this.textarea.m_239249_();
        this.m_6575_(mc, x, y);
        super.m_6574_(mc, x, y);
        this.textarea.m_240159_(prev);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = pGuiGraphics.m_280168_();
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        SFMWidgetUtils.hideTooltipsWhenNotFocused(this, this.f_169369_);
        SFMWidgetUtils.renderChildTooltips(poseStack, pMouseX, pMouseY, this.f_169369_);
        if (!this.MENU.logLevel.equals(this.lastKnownLogLevel)) {
            this.onLogLevelChange();
        }
    }

    public boolean shouldRebuildText() {
        return this.MENU.logs.size() != this.lastSize;
    }

    public void rebuildText() {
        if (this.MENU.logs.isEmpty() && this.MENU.logLevel.equals(Level.OFF.name())) {
            this.MENU.logs.add(new TranslatableLogEvent(Level.INFO, SFMEpochInstant.now(), LocalizationKeys.LOGS_GUI_NO_CONTENT.get()));
        }
        this.textarea.styledTextContentLines = LogsTextStylingHelper.getStyledLogs(this.MENU.logs);
        StringBuilder sb = new StringBuilder();
        for (MutableComponent line : this.textarea.styledTextContentLines) {
            sb.append(line.getString()).append("\n");
        }
        this.textarea.m_240159_(sb.toString());
        this.textarea.textRenderWidget.setStyledTextContentLines(this.textarea.styledTextContentLines);
        this.textarea.textRenderWidget.setTextContent(this.textarea.m_239249_());
        this.lastSize = this.MENU.logs.size();
    }

    protected void m_7856_() {
        Level[] levelArray;
        super.m_7856_();
        assert (this.f_96541_ != null);
        this.textarea = (LogsScreenMultiLineEditBox)this.m_142416_((GuiEventListener)new LogsScreenMultiLineEditBox(this, this.f_96547_, this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 90, 400, 180, (Component)Component.m_237113_((String)""), (Component)Component.m_237113_((String)"")));
        this.rebuildText();
        this.m_264313_((GuiEventListener)this.textarea);
        if (this.isReadOnly()) {
            levelArray = new Level[]{};
        } else {
            Level[] levelArray2 = new Level[6];
            levelArray2[0] = Level.OFF;
            levelArray2[1] = Level.TRACE;
            levelArray2[2] = Level.DEBUG;
            levelArray2[3] = Level.INFO;
            levelArray2[4] = Level.WARN;
            levelArray = levelArray2;
            levelArray2[5] = Level.ERROR;
        }
        Level[] buttons = levelArray;
        int buttonWidth = 60;
        int buttonHeight = 20;
        int spacing = 5;
        int startX = (this.f_96543_ - (buttonWidth * buttons.length + spacing * 4)) / 2;
        int startY = this.f_96544_ / 2 - 115;
        int buttonIndex = 0;
        this.levelButtons = new HashMap<Level, Button>();
        for (Level level : buttons) {
            Button levelButton = new SFMButtonBuilder().setSize(buttonWidth, buttonHeight).setPosition(startX + (buttonWidth + spacing) * buttonIndex, startY).setText((Component)Component.m_237113_((String)level.name())).setOnPress(button -> {
                String logLevel = level.name();
                SFMPackets.sendToServer(new ServerboundManagerSetLogLevelPacket(this.MENU.f_38840_, this.MENU.MANAGER_POSITION, logLevel));
                this.MENU.logLevel = logLevel;
                this.onLogLevelChange();
            }).build();
            this.levelButtons.put(level, levelButton);
            this.m_142416_((GuiEventListener)levelButton);
            ++buttonIndex;
        }
        this.onLogLevelChange();
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 100 + 195).setSize(80, 20).setText(LocalizationKeys.LOGS_GUI_COPY_LOGS_BUTTON).setOnPress(this::onCopyLogsClicked).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.LOGS_GUI_COPY_LOGS_BUTTON_TOOLTIP).build());
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 2 - 100, this.f_96544_ / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.f_130655_).setOnPress(p_97691_ -> this.m_7379_()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        if (!this.isReadOnly()) {
            this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 2 + 115, this.f_96544_ / 2 - 100 + 195).setSize(80, 20).setText(LocalizationKeys.LOGS_GUI_CLEAR_LOGS_BUTTON).setOnPress(button -> {
                SFMPackets.sendToServer(new ServerboundManagerClearLogsPacket(this.MENU.f_38840_, this.MENU.MANAGER_POSITION));
                this.MENU.logs.clear();
            }).build());
        }
    }

    private void onCopyLogsClicked(Button button) {
        StringBuilder clipboardBuilder = new StringBuilder();
        clipboardBuilder.append(SFMDiagnostics.getDiagnosticsSummary(this.MENU.getDisk()));
        clipboardBuilder.append("\n-- LOGS --\n");
        if (LogsScreen.m_96638_()) {
            for (TranslatableLogEvent log : this.MENU.logs) {
                clipboardBuilder.append(log.level().name()).append(" ");
                clipboardBuilder.append(log.instant().toString()).append(" ");
                clipboardBuilder.append(log.contents().m_237508_());
                for (Object arg : log.contents().m_237523_()) {
                    clipboardBuilder.append(" ").append(arg);
                }
                clipboardBuilder.append("\n");
            }
        } else {
            for (MutableComponent line : this.textarea.styledTextContentLines) {
                clipboardBuilder.append(line.getString()).append("\n");
            }
        }
        Minecraft.m_91087_().f_91068_.m_90911_(clipboardBuilder.toString());
    }
}

