/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.net.ServerboundNetworkToolToggleOverlayPacket;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.SFMHandUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class NetworkToolKeyMappingHandler {
    private static ToggleKeyState toggleKeyState = ToggleKeyState.Idle;

    public static void setExternalDebounce() {
        toggleKeyState = ToggleKeyState.PressCancelledExternally;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        NetworkToolKeyMappingHandler.handleAltKeyLogic();
    }

    private static void handleAltKeyLogic() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen != null) {
            return;
        }
        boolean alt_down = SFMKeyMappings.isKeyDown(SFMKeyMappings.TOGGLE_NETWORK_TOOL_OVERLAY_KEY);
        switch (toggleKeyState) {
            case Idle: {
                if (!alt_down) break;
                toggleKeyState = ToggleKeyState.Pressed;
                break;
            }
            case Pressed: {
                if (alt_down) break;
                toggleKeyState = ToggleKeyState.Idle;
                assert (minecraft.player != null);
                InteractionHand hand = SFMHandUtils.getHandHoldingItem((Player)minecraft.player, SFMItems.NETWORK_TOOL_ITEM.get());
                if (hand == null) {
                    return;
                }
                SFMPackets.sendToServer(new ServerboundNetworkToolToggleOverlayPacket(hand));
                break;
            }
            case PressCancelledExternally: {
                if (alt_down) break;
                toggleKeyState = ToggleKeyState.Idle;
            }
        }
    }

    private static enum ToggleKeyState {
        Idle,
        Pressed,
        PressCancelledExternally;

    }
}

