/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.facade;

import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.blockentity.IFacadeBlockEntity;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.facade.ApplyFacadesFacadePlan;
import ca.teamdman.sfm.common.facade.ChangeWorldBlockFacadePlan;
import ca.teamdman.sfm.common.facade.ClearFacadesFacadePlan;
import ca.teamdman.sfm.common.facade.FacadeData;
import ca.teamdman.sfm.common.facade.FacadeSpreadLogic;
import ca.teamdman.sfm.common.facade.FacadeTextureMode;
import ca.teamdman.sfm.common.facade.FacadeTransparency;
import ca.teamdman.sfm.common.facade.IFacadePlan;
import ca.teamdman.sfm.common.net.ServerboundFacadePacket;
import ca.teamdman.sfm.common.util.InPlaceBlockPlaceContext;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import ca.teamdman.sfm.common.util.Stored;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacadePlanner {
    @Nullable
    public static IFacadePlan getFacadePlan(Player player, Level level, ServerboundFacadePacket msg) {
        boolean paintingWithAir;
        BlockPos hitPos = msg.hitResult().getBlockPos();
        if (!level.isLoaded(hitPos)) {
            return null;
        }
        BlockState hitBlockState = level.getBlockState(hitPos);
        Block hitBlock = hitBlockState.getBlock();
        if (!(hitBlock instanceof IFacadableBlock)) {
            return null;
        }
        IFacadableBlock hitFacadable = (IFacadableBlock)hitBlock;
        Item paintItem = msg.paintStack().getItem();
        boolean bl = paintingWithAir = paintItem == Items.AIR;
        if (paintingWithAir) {
            return new ClearFacadesFacadePlan(FacadePlanner.getPositions(level, msg, hitPos, hitBlock));
        }
        @Nullable Block renderBlock = Block.byItem((Item)paintItem);
        if (renderBlock == Blocks.AIR) {
            return null;
        }
        if (renderBlock instanceof IFacadableBlock) {
            boolean isSameShape;
            IFacadableBlock renderFacadable = (IFacadableBlock)renderBlock;
            boolean bl2 = isSameShape = hitFacadable.getNonFacadeBlock() == renderFacadable.getNonFacadeBlock();
            if (isSameShape) {
                return new ClearFacadesFacadePlan(FacadePlanner.getPositions(level, msg, hitPos, hitBlock));
            }
            return new ChangeWorldBlockFacadePlan(renderFacadable.getFacadeBlock(), FacadePlanner.getPositions(level, msg, hitPos, hitBlock));
        }
        BlockState renderBlockState = Objects.requireNonNullElse(renderBlock.getStateForPlacement((BlockPlaceContext)new InPlaceBlockPlaceContext(player, msg.paintHand(), msg.paintStack(), msg.hitResult())), renderBlock.defaultBlockState());
        FacadeTransparency facadeTransparency = renderBlockState.isSolidRender((BlockGetter)level, hitPos) ? FacadeTransparency.OPAQUE : FacadeTransparency.TRANSLUCENT;
        return new ApplyFacadesFacadePlan(new FacadeData(renderBlockState, msg.hitResult().getDirection(), FacadeTextureMode.FILL), facadeTransparency, FacadePlanner.getPositions(level, msg, hitPos, hitBlock));
    }

    @NotNull
    private static Set<BlockPos> getPositions(Level level, ServerboundFacadePacket msg, @Stored BlockPos hitPos, Block hitBlock) {
        Set<BlockPos> positions = switch (msg.spreadLogic()) {
            default -> throw new IncompatibleClassChangeError();
            case FacadeSpreadLogic.SINGLE -> {
                HashSet set = new HashSet();
                set.add(hitPos);
                yield set;
            }
            case FacadeSpreadLogic.NETWORK -> CableNetwork.discoverCables(level, hitPos).collect(Collectors.toSet());
            case FacadeSpreadLogic.NETWORK_GLOBAL_SAME_PAINT -> {
                Object existingFacadeBlockEntityClass;
                BlockEntity var6_5 = level.getBlockEntity(hitPos);
                if (var6_5 instanceof IFacadeBlockEntity) {
                    IFacadeBlockEntity startFacadeBlockEntity = (IFacadeBlockEntity)var6_5;
                    FacadeData existingFacadeData = startFacadeBlockEntity.getFacadeData();
                    existingFacadeBlockEntityClass = startFacadeBlockEntity.getClass();
                    yield CableNetwork.discoverCables(level, hitPos).filter(arg_0 -> FacadePlanner.lambda$getPositions$0(level, (Class)existingFacadeBlockEntityClass, existingFacadeData, arg_0)).collect(Collectors.toSet());
                }
                yield CableNetwork.discoverCables(level, hitPos).filter(checkPos -> level.getBlockState(checkPos).getBlock() == hitBlock).filter(checkPos -> !(level.getBlockEntity(checkPos) instanceof IFacadeBlockEntity)).collect(Collectors.toSet());
            }
            case FacadeSpreadLogic.NETWORK_CONTIGUOUS_SAME_PAINT -> {
                Set cablePositions = CableNetwork.discoverCables(level, hitPos).collect(Collectors.toSet());
                Object existingFacadeBlockEntityClass = level.getBlockEntity(hitPos);
                if (existingFacadeBlockEntityClass instanceof IFacadeBlockEntity) {
                    IFacadeBlockEntity startFacadeBlockEntity = (IFacadeBlockEntity)existingFacadeBlockEntityClass;
                    existingFacadeBlockEntityClass = startFacadeBlockEntity.getClass();
                    FacadeData existingFacadeData = startFacadeBlockEntity.getFacadeData();
                    yield SFMStreamUtils.getRecursiveStream((arg_0, arg_1, arg_2) -> FacadePlanner.lambda$getPositions$4(cablePositions, level, (Class)existingFacadeBlockEntityClass, existingFacadeData, arg_0, arg_1, arg_2), hitPos).collect(Collectors.toSet());
                }
                yield SFMStreamUtils.getRecursiveStream((current, next, results) -> {
                    results.accept(current);
                    SFMStreamUtils.get3DNeighboursIncludingKittyCorner(current).filter(neighbour -> {
                        if (!cablePositions.contains(neighbour)) {
                            return false;
                        }
                        Block neighbourBlock = level.getBlockState(neighbour).getBlock();
                        return neighbourBlock == hitBlock;
                    }).forEach(next);
                }, hitPos).collect(Collectors.toSet());
            }
        };
        positions.removeIf(pos -> level.getBlockEntity(pos) instanceof ManagerBlockEntity);
        return positions;
    }

    private static /* synthetic */ void lambda$getPositions$4(Set cablePositions, Level level, Class existingFacadeBlockEntityClass, FacadeData existingFacadeData, BlockPos current, Consumer next, Consumer results) {
        results.accept(current);
        SFMStreamUtils.get3DNeighboursIncludingKittyCorner(current).filter(neighbour -> {
            IFacadeBlockEntity otherCableFacadeBlockEntity;
            if (!cablePositions.contains(neighbour)) {
                return false;
            }
            BlockEntity patt8075$temp = level.getBlockEntity(neighbour);
            if (patt8075$temp instanceof IFacadeBlockEntity && (otherCableFacadeBlockEntity = (IFacadeBlockEntity)patt8075$temp).getClass().equals(existingFacadeBlockEntityClass)) {
                FacadeData otherFacadeData = otherCableFacadeBlockEntity.getFacadeData();
                return Objects.equals(otherFacadeData, existingFacadeData);
            }
            return false;
        }).forEach(next);
    }

    private static /* synthetic */ boolean lambda$getPositions$0(Level level, Class existingFacadeBlockEntityClass, FacadeData existingFacadeData, BlockPos cablePos) {
        IFacadeBlockEntity otherFacadeBlockEntity;
        BlockEntity patt5718$temp = level.getBlockEntity(cablePos);
        if (patt5718$temp instanceof IFacadeBlockEntity && (otherFacadeBlockEntity = (IFacadeBlockEntity)patt5718$temp).getClass().equals(existingFacadeBlockEntityClass)) {
            return Objects.equals(otherFacadeBlockEntity.getFacadeData(), existingFacadeData);
        }
        return false;
    }
}

