/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.recipe;

import ca.teamdman.sfm.common.blockentity.PrintingPressBlockEntity;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.registry.SFMRecipeSerializers;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PrintingPressRecipe
implements Recipe<PrintingPressBlockEntity> {
    public final Ingredient FORM;
    public final Ingredient INK;
    public final Ingredient PAPER;

    public PrintingPressRecipe(Ingredient form, Ingredient ink, Ingredient paper) {
        this.FORM = form;
        this.INK = ink;
        this.PAPER = paper;
    }

    public boolean matches(PrintingPressBlockEntity pContainer, Level pLevel) {
        return this.PAPER.test(pContainer.getPaper()) && this.INK.test(pContainer.getInk()) && this.FORM.test(FormItem.getBorrowedReferenceFromForm(pContainer.getForm()));
    }

    public ItemStack assemble(PrintingPressBlockEntity pContainer, RegistryAccess p_267165_) {
        ItemStack rtn = FormItem.getCopiedReferenceFromForm(pContainer.getForm());
        rtn.setCount(pContainer.getPaper().getCount());
        return rtn;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(RegistryAccess p_267052_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return SFMRecipeSerializers.PRINTING_PRESS.get();
    }

    public RecipeType<?> getType() {
        return SFMRecipeTypes.PRINTING_PRESS.get();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PrintingPressRecipe that = (PrintingPressRecipe)obj;
        return Objects.equals(this.FORM, that.FORM) && Objects.equals(this.INK, that.INK) && Objects.equals(this.PAPER, that.PAPER);
    }

    public int hashCode() {
        return Objects.hash(this.FORM, this.INK, this.PAPER);
    }

    public String toString() {
        return "PrintingPressRecipe[form=" + String.valueOf(this.FORM) + ", ink=" + String.valueOf(this.INK) + ", paper=" + String.valueOf(this.PAPER) + "]";
    }

    public static class Serializer
    implements RecipeSerializer<PrintingPressRecipe> {
        private final Codec<PrintingPressRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("form").forGetter(recipe -> recipe.FORM), (App)Ingredient.CODEC.fieldOf("ink").forGetter(recipe -> recipe.INK), (App)Ingredient.CODEC.fieldOf("paper").forGetter(recipe -> recipe.PAPER)).apply((Applicative)instance, PrintingPressRecipe::new));

        public Codec<PrintingPressRecipe> codec() {
            return this.CODEC;
        }

        public PrintingPressRecipe fromNetwork(FriendlyByteBuf friendlyByteBuf) {
            Ingredient form = Ingredient.fromNetwork((FriendlyByteBuf)friendlyByteBuf);
            Ingredient ink = Ingredient.fromNetwork((FriendlyByteBuf)friendlyByteBuf);
            Ingredient paper = Ingredient.fromNetwork((FriendlyByteBuf)friendlyByteBuf);
            return new PrintingPressRecipe(form, ink, paper);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PrintingPressRecipe pRecipe) {
            pRecipe.FORM.toNetwork(pBuffer);
            pRecipe.INK.toNetwork(pBuffer);
            pRecipe.PAPER.toNetwork(pBuffer);
        }
    }
}

