/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.examples;

import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfml.program_builder.ProgramBuildResult;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SFMExampleProgram(String displayName, String programString) implements Comparable<SFMExampleProgram>
{
    public static List<SFMExampleProgram> gatherAll() {
        Map exampleResources = Minecraft.m_91087_().m_91098_().m_214159_("template_programs", SFMExampleProgram::isSFMLProgram);
        ArrayList<SFMExampleProgram> rtn = new ArrayList<SFMExampleProgram>();
        for (Map.Entry exampleResource : exampleResources.entrySet()) {
            Resource resource;
            ResourceLocation path = (ResourceLocation)exampleResource.getKey();
            SFMExampleProgram program = SFMExampleProgram.fromResource(path, resource = (Resource)exampleResource.getValue());
            if (program == null) continue;
            rtn.add(program);
        }
        rtn.sort(Comparator.naturalOrder());
        return rtn;
    }

    public static SFMExampleProgram getChangelog() {
        for (SFMExampleProgram e : SFMExampleProgram.gatherAll()) {
            if (!e.displayName().equals("Changelog")) continue;
            return e;
        }
        return new SFMExampleProgram("Failed to load changelog", "Failed to load changelog");
    }

    public static boolean isSFMLProgram(ResourceLocation path) {
        return path.m_135815_().endsWith(".sfml") || path.m_135815_().endsWith(".sfm");
    }

    @Override
    public int compareTo(@NotNull SFMExampleProgram o) {
        return this.displayName().compareTo(o.displayName());
    }

    @Nullable
    private static SFMExampleProgram fromResource(ResourceLocation path, Resource resource) {
        String programString = SFMExampleProgram.readProgramStringFromResource(resource);
        if (programString == null) {
            return null;
        }
        ProgramBuildResult result = new ProgramBuilder(programString).build();
        String displayName = result.program() == null ? String.format("(compile failed) %s", path.toString()) : result.program().name();
        return new SFMExampleProgram(displayName, programString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String readProgramStringFromResource(Resource resource) {
        try (BufferedReader reader = resource.m_215508_();){
            String programString = reader.lines().collect(Collectors.joining("\n"));
            if (!programString.contains("$REPLACE_RESOURCE_TYPES_HERE$")) {
                String string2 = programString;
                return string2;
            }
            List<? extends String> disallowedResourceTypesForTransfer = SFMConfig.getOrDefault(SFMConfig.SERVER_CONFIG.disallowedResourceTypesForTransfer);
            String replacement = SFMResourceTypes.registry().keys().stream().map(ResourceLocation::m_135815_).map(e -> {
                Object text = "";
                if (disallowedResourceTypesForTransfer.contains(e)) {
                    text = (String)text + "-- (disallowed in config) ";
                }
                text = (String)text + "INPUT " + e + ":: FROM a";
                return text;
            }).collect(Collectors.joining("\n    "));
            String string = programString = programString.replace("$REPLACE_RESOURCE_TYPES_HERE$", replacement);
            return string;
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

