/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.client.ClientTranslationHelpers;
import ca.teamdman.sfm.client.text_styling.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.Level;

public class LogsTextStylingHelper {
    public static List<MutableComponent> getStyledLogs(Iterable<TranslatableLogEvent> logs) {
        ArrayList<MutableComponent> processedLogs = new ArrayList<MutableComponent>();
        for (TranslatableLogEvent log : logs) {
            int secondsAgo = Math.toIntExact(log.instant().elapsed().toSeconds());
            int minutes = secondsAgo / 60;
            MutableComponent ago = Component.m_237113_((String)(minutes + "m" + (secondsAgo %= 60) + "s ago")).m_130940_(ChatFormatting.GRAY);
            MutableComponent level = Component.m_237113_((String)(" [" + log.level() + "] "));
            if (log.level() == Level.ERROR) {
                level = level.m_130940_(ChatFormatting.RED);
            } else if (log.level() == Level.WARN) {
                level = level.m_130940_(ChatFormatting.YELLOW);
            } else if (log.level() == Level.INFO) {
                level = level.m_130940_(ChatFormatting.GREEN);
            } else if (log.level() == Level.DEBUG) {
                level = level.m_130940_(ChatFormatting.AQUA);
            } else if (log.level() == Level.TRACE) {
                level = level.m_130940_(ChatFormatting.DARK_GRAY);
            }
            String[] lines = ClientTranslationHelpers.resolveTranslation(log.contents()).split("\n", -1);
            StringBuilder codeBlock = new StringBuilder();
            boolean insideCodeBlock = false;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.equals("```")) {
                    if (insideCodeBlock) {
                        List<MutableComponent> codeLines = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(codeBlock.toString(), false);
                        processedLogs.addAll(codeLines);
                        codeBlock = new StringBuilder();
                        continue;
                    }
                    insideCodeBlock = true;
                    continue;
                }
                if (insideCodeBlock) {
                    codeBlock.append(line).append("\n");
                    continue;
                }
                MutableComponent lineComponent = Component.m_237113_((String)line).m_130940_(ChatFormatting.WHITE);
                if (i == 0) {
                    lineComponent = ago.m_7220_((Component)level).m_7220_((Component)lineComponent);
                }
                processedLogs.add(lineComponent);
            }
        }
        return processedLogs;
    }
}

