/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen.text_editor;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ProgramTokenContextActions;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.screen.SFMTextEditorConfigScreen;
import ca.teamdman.sfm.client.screen.SFMWidgetUtils;
import ca.teamdman.sfm.client.screen.text_editor.ISFMTextEditScreen;
import ca.teamdman.sfm.client.screen.text_editor.SFMTextEditorUtils;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditScreenOpenContext;
import ca.teamdman.sfm.client.text_editor.SFMTextEditorIntellisenseLevel;
import ca.teamdman.sfm.client.text_styling.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.widget.PickList;
import ca.teamdman.sfm.client.widget.PickListItem;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMComponentUtils;
import ca.teamdman.sfm.common.util.SFMDisplayUtils;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.intellisense.IntellisenseAction;
import ca.teamdman.sfml.intellisense.IntellisenseContext;
import ca.teamdman.sfml.intellisense.SFMLIntellisense;
import ca.teamdman.sfml.manipulation.ManipulationResult;
import ca.teamdman.sfml.manipulation.ProgramStringManipulationUtils;
import ca.teamdman.sfml.program_builder.ProgramBuildResult;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class SFMTextEditScreenV1
extends Screen
implements ISFMTextEditScreen {
    private final ISFMTextEditScreenOpenContext openContext;
    protected MyMultiLineEditBox textarea;
    protected String lastProgram = "";
    protected List<MutableComponent> content = new ArrayList<MutableComponent>();
    protected PickList<IntellisenseAction> suggestedActions;
    private boolean scrolledOnFirstInit = false;

    public SFMTextEditScreenV1(ISFMTextEditScreenOpenContext openContext) {
        super((Component)LocalizationKeys.TEXT_EDIT_SCREEN_TITLE.getComponent());
        this.openContext = openContext;
    }

    public void scrollToTop() {
        this.textarea.scrollToTop();
    }

    public boolean m_7043_() {
        return false;
    }

    public void saveAndClose() {
        this.openContext.onSaveAndClose(this.textarea.m_239249_());
    }

    public void m_7379_() {
        this.openContext.onTryClose(this.textarea.m_239249_(), SFMScreenChangeHelpers::popScreen);
    }

    @Override
    public ISFMTextEditScreenOpenContext openContext() {
        return this.openContext;
    }

    @Override
    public void onPreferenceChanged() {
        this.textarea.rebuildIntellisense();
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.m_96637_());
            return true;
        }
        return false;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (Screen.m_96637_() && pCodePoint == ' ') {
            return true;
        }
        if (!this.suggestedActions.isEmpty() && pCodePoint == '\\') {
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && Screen.m_96638_()) {
            this.saveAndClose();
            return true;
        }
        if (pKeyCode == 258) {
            String content = this.textarea.m_239249_();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            double scrollAmount = this.textarea.getScrollAmount();
            ManipulationResult result = Screen.m_96638_() ? ProgramStringManipulationUtils.deindent(content, cursor, selectionCursor) : ProgramStringManipulationUtils.indent(content, cursor, selectionCursor);
            this.textarea.m_240159_(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.m_240206_(scrollAmount);
            return true;
        }
        if (pKeyCode == 92 && !this.suggestedActions.isEmpty()) {
            IntellisenseAction action = this.suggestedActions.getSelected();
            assert (action != null);
            ManipulationResult result = action.perform(new IntellisenseContext(new ProgramBuilder(this.textarea.m_239249_()).build(), this.textarea.getCursorPosition(), this.textarea.getSelectionCursorPosition(), this.openContext.labelPositionHolder(), (SFMTextEditorIntellisenseLevel)((Object)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.intellisenseLevel.get())));
            double scrollAmount = this.textarea.getScrollAmount();
            this.textarea.m_240159_(result.content());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.m_240206_(scrollAmount);
            return true;
        }
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.m_96637_());
            return true;
        }
        if (pKeyCode == 47 && Screen.m_96637_()) {
            String content = this.textarea.m_239249_();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            ManipulationResult result = ProgramStringManipulationUtils.toggleComments(content, cursor, selectionCursor);
            this.textarea.m_240159_(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 32 && Screen.m_96637_()) {
            ProgramTokenContextActions.getContextAction(this.textarea.m_239249_(), this.textarea.getCursorPosition()).ifPresent(Runnable::run);
            this.textarea.rebuild(false);
            return true;
        }
        if (!(pKeyCode != 265 && pKeyCode != 264 || this.suggestedActions.getItems().isEmpty())) {
            if (pKeyCode == 265) {
                this.suggestedActions.selectPreviousWrapping();
            } else {
                this.suggestedActions.selectNextWrapping();
            }
            return true;
        }
        if (pKeyCode == 256 && !this.suggestedActions.isEmpty()) {
            this.suggestedActions.clear();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String prev = this.textarea.m_239249_();
        this.m_6575_(mc, x, y);
        super.m_6574_(mc, x, y);
        this.textarea.m_240159_(prev);
    }

    public void m_6305_(PoseStack poseStack, int mx, int my, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mx, my, partialTicks);
        SFMWidgetUtils.hideTooltipsWhenNotFocused(this, this.f_169369_);
        SFMWidgetUtils.renderChildTooltips(poseStack, mx, my, this.f_169369_);
    }

    protected void m_7856_() {
        super.m_7856_();
        SFMScreenRenderUtils.enableKeyRepeating();
        this.textarea = (MyMultiLineEditBox)this.m_142416_((GuiEventListener)new MyMultiLineEditBox(this.f_96547_, this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 110, 400, 200, (Component)Component.m_237113_((String)""), (Component)Component.m_237113_((String)"")));
        Objects.requireNonNull(this.f_96547_);
        this.suggestedActions = (PickList)this.m_142416_((GuiEventListener)new PickList(this.f_96547_, 0, 0, 180, 9 * 6, (Component)LocalizationKeys.INTELLISENSE_PICK_LIST_GUI_TITLE.getComponent(), new ArrayList()));
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 100 + 195).setSize(16, 20).setText((Component)Component.m_237113_((String)"#")).setOnPress(button -> {
            int cursorPos = this.textarea.getCursorPosition();
            int selectionCursorPos = this.textarea.getSelectionCursorPosition();
            SFMScreenChangeHelpers.setOrPushScreen(new SFMTextEditorConfigScreen(this, SFMConfig.CLIENT_TEXT_EDITOR_CONFIG, () -> {
                this.m_94718_((GuiEventListener)this.textarea);
                this.textarea.setCursorPosition(cursorPos);
                this.textarea.setSelectionCursorPosition(selectionCursorPos);
            }));
        }).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.PROGRAM_EDIT_SCREEN_CONFIG_BUTTON_TOOLTIP).build());
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 2 - 150, this.f_96544_ / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.f_130655_).setOnPress(button -> this.saveAndClose()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 2 + 100, this.f_96544_ / 2 - 100 + 195).setSize(100, 20).setText(CommonComponents.f_130656_).setOnPress(button -> this.m_7379_()).build());
        this.textarea.m_240159_(this.openContext.initialValue());
        if (!this.scrolledOnFirstInit) {
            this.scrollToTop();
            this.scrolledOnFirstInit = true;
        }
        this.m_94718_((GuiEventListener)this.textarea);
    }

    public void m_86600_() {
        this.textarea.m_239213_();
    }

    protected class MyMultiLineEditBox
    extends MultiLineEditBox {
        private final List<Integer> displayedLineStartOffsets;
        @Nullable
        private ProgramBuildResult cachedBuildResult;
        private String cachedBuildProgram;
        private boolean scrollbarDragActive;
        private boolean scrollingEnabled;
        private int cursorBlinkTick;

        public MyMultiLineEditBox(Font pFont, int pX, int pY, int pWidth, int pHeight, Component pPlaceholder, Component pMessage) {
            super(pFont, pX, pY, pWidth, pHeight, pPlaceholder, pMessage);
            this.displayedLineStartOffsets = new ArrayList<Integer>();
            this.cachedBuildProgram = "";
            this.scrollingEnabled = true;
            this.cursorBlinkTick = 0;
            this.f_238540_.m_239919_(this::onValueOrCursorChanged);
            this.f_238540_.m_239257_(() -> this.onValueOrCursorChanged(this.f_238540_.m_239618_()));
            this.rebuild(false);
        }

        public void scrollToTop() {
            this.m_240206_(0.0);
        }

        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
        }

        public int getCursorPosition() {
            return this.f_238540_.f_238566_;
        }

        public void setCursorPosition(int cursor) {
            this.f_238540_.m_239797_(Whence.ABSOLUTE, cursor);
        }

        public int m_240211_() {
            int rtn = super.m_240211_();
            if (rtn == this.f_93619_) {
                return rtn - 1;
            }
            return rtn;
        }

        @MCVersionDependentBehaviour
        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            try {
                boolean clickedScrollbar;
                if (pButton == 0) {
                    this.scrollbarDragActive = false;
                }
                if (pButton == 0 && this.f_93624_ && this.m_239606_(pMouseX, pMouseY)) {
                    if (SFMTextEditScreenV1.this.content.isEmpty()) {
                        return false;
                    }
                    this.m_93692_(true);
                    boolean shiftDown = Screen.m_96638_();
                    this.seekCursorFromPoint(pMouseX, pMouseY);
                    if (!shiftDown) {
                        this.f_238540_.f_238550_ = this.f_238540_.f_238566_;
                    }
                    this.f_238540_.m_239950_(true);
                    return true;
                }
                boolean bl = clickedScrollbar = pButton == 0 && this.f_93624_ && this.m_239656_() && pMouseX >= (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.f_93618_) && pMouseX <= (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.f_93618_ + 8) && pMouseY >= (double)SFMWidgetUtils.getY((AbstractWidget)this) && pMouseY < (double)(SFMWidgetUtils.getY((AbstractWidget)this) + this.f_93619_);
                if (clickedScrollbar) {
                    this.scrollbarDragActive = true;
                }
                return super.m_6375_(pMouseX, pMouseY, pButton);
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in SFMTextEditScreenV1.MyMultiLineEditBox.mouseClicked", (Throwable)e);
                return false;
            }
        }

        public int m_239019_() {
            Objects.requireNonNull(this.f_238790_);
            return 9 * (SFMTextEditScreenV1.this.content.size() + 2);
        }

        public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
            if (this.scrollbarDragActive && super.m_7979_(mx, my, button, dx, dy)) {
                return true;
            }
            try {
                if (button == 0 && this.f_93624_ && this.m_239606_(mx, my)) {
                    if (SFMTextEditScreenV1.this.content.isEmpty()) {
                        return false;
                    }
                    this.f_238540_.m_239950_(true);
                    this.seekCursorFromPoint(mx, my);
                    return true;
                }
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in SFMTextEditScreenV1.MyMultiLineEditBox.mouseDragged", (Throwable)e);
                return false;
            }
            return false;
        }

        public boolean m_6348_(double mx, double my, int button) {
            if (button == 0) {
                this.f_238540_.m_239950_(false);
                this.scrollbarDragActive = false;
            }
            return super.m_6348_(mx, my, button);
        }

        public int getSelectionCursorPosition() {
            return this.f_238540_.f_238550_;
        }

        public void setSelectionCursorPosition(int cursor) {
            this.f_238540_.f_238550_ = cursor;
        }

        public double getScrollAmount() {
            return this.m_239030_();
        }

        protected void m_240206_(double pScrollAmount) {
            if (!this.scrollingEnabled) {
                return;
            }
            super.m_240206_(pScrollAmount);
        }

        private void seekCursorFromPoint(double mx, double my) {
            int lineCount = SFMTextEditScreenV1.this.content.size();
            double innerX = mx - (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.m_239244_() + SFMTextEditorUtils.getLineNumberWidth(this.f_238790_, lineCount));
            double innerY = my - (double)(SFMWidgetUtils.getY((AbstractWidget)this) + this.m_239244_()) + this.m_239030_();
            Objects.requireNonNull(this.f_238790_);
            int lineIndex = Mth.m_14045_((int)((int)Math.floor(innerY / (double)Math.max(1, 9))), (int)0, (int)Math.max(0, lineCount - 1));
            int cursorPosition = this.pointToCursor(innerX, lineIndex);
            this.scrollingEnabled = false;
            this.f_238540_.m_239797_(Whence.ABSOLUTE, cursorPosition);
            this.scrollingEnabled = true;
        }

        private int getLineStartIndex(int lineIndex) {
            if (this.displayedLineStartOffsets.isEmpty()) {
                return 0;
            }
            int clamped = Mth.m_14045_((int)lineIndex, (int)0, (int)Math.max(0, this.displayedLineStartOffsets.size() - 1));
            return this.displayedLineStartOffsets.get(clamped);
        }

        private int pointToCursor(double innerX, int lineIndex) {
            int nextGlyphWidth;
            int lineStartIndex = this.getLineStartIndex(lineIndex);
            if (SFMTextEditScreenV1.this.content.isEmpty()) {
                return lineStartIndex;
            }
            int clampedLine = Mth.m_14045_((int)lineIndex, (int)0, (int)Math.max(0, SFMTextEditScreenV1.this.content.size() - 1));
            String plainLine = SFMTextEditScreenV1.this.content.get(clampedLine).getString();
            int clampedX = (int)Math.max(0.0, innerX);
            int cursorOffsetInLine = this.f_238790_.m_92834_(plainLine, clampedX).length();
            int widthBeforeCursor = this.f_238790_.m_92895_(plainLine.substring(0, cursorOffsetInLine));
            if (cursorOffsetInLine < plainLine.length() && (double)(clampedX - widthBeforeCursor) >= (double)(nextGlyphWidth = this.f_238790_.m_92895_(plainLine.substring(cursorOffsetInLine, cursorOffsetInLine + 1))) / 2.0) {
                cursorOffsetInLine = Math.min(plainLine.length(), cursorOffsetInLine + 1);
            }
            return Mth.m_14045_((int)(lineStartIndex + cursorOffsetInLine), (int)0, (int)this.f_238540_.m_239618_().length());
        }

        protected int m_239509_() {
            return Math.max(1, super.m_239509_());
        }

        private void onValueOrCursorChanged(String programString) {
            ProgramBuildResult buildResult;
            int cursorPosition = this.getCursorPosition();
            if (programString.equals(this.cachedBuildProgram) && this.cachedBuildResult != null) {
                buildResult = this.cachedBuildResult;
            } else {
                buildResult = new ProgramBuilder(programString).build();
                this.cachedBuildProgram = programString;
                this.cachedBuildResult = buildResult;
            }
            IntellisenseContext intellisenseContext = new IntellisenseContext(buildResult, cursorPosition, this.getSelectionCursorPosition(), SFMTextEditScreenV1.this.openContext.labelPositionHolder(), (SFMTextEditorIntellisenseLevel)((Object)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.intellisenseLevel.get()));
            List<IntellisenseAction> suggestions = SFMLIntellisense.getSuggestions(intellisenseContext);
            SFMTextEditScreenV1.this.suggestedActions.setItems(suggestions);
            String cursorWord = buildResult.getWordAtCursorPosition(cursorPosition);
            SFMTextEditScreenV1.this.suggestedActions.setQuery((Component)Component.m_237113_((String)cursorWord));
            boolean shouldPrint = false;
            if (shouldPrint) {
                String cursorPositionDisplay = SFMDisplayUtils.getCursorPositionDisplay(programString, cursorPosition);
                String cursorTokenDisplay = SFMDisplayUtils.getCursorTokenDisplay(buildResult, cursorPosition);
                @Nullable Program program = buildResult.program();
                String tokenHierarchyDisplay = program == null ? "<INVALID PROGRAM>" : SFMDisplayUtils.getTokenHierarchyDisplay(program, cursorPosition);
                String suggestionsDisplay = SFMTextEditScreenV1.this.suggestedActions.getItems().stream().map(PickListItem::getComponent).map(Component::getString).collect(Collectors.joining(", "));
                SFM.LOGGER.info("PROGRAM OR CURSOR CHANGE! {}   {}   {}  |||  {} ||| {}", (Object)cursorPositionDisplay, (Object)cursorTokenDisplay, (Object)tokenHierarchyDisplay, (Object)cursorWord, (Object)suggestionsDisplay);
            }
        }

        private void rebuildIntellisense() {
            this.onValueOrCursorChanged(this.m_239249_());
        }

        private void rebuild(boolean showContextActionHints) {
            SFMTextEditScreenV1.this.lastProgram = this.f_238540_.m_239618_();
            SFMTextEditScreenV1.this.content = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(SFMTextEditScreenV1.this.lastProgram, showContextActionHints);
            this.rebuildDisplayCache();
        }

        private void rebuildDisplayCache() {
            this.displayedLineStartOffsets.clear();
            this.displayedLineStartOffsets.add(0);
            for (int i = 0; i < SFMTextEditScreenV1.this.lastProgram.length(); ++i) {
                if (SFMTextEditScreenV1.this.lastProgram.charAt(i) != '\n') continue;
                this.displayedLineStartOffsets.add(i + 1);
            }
            int lines = SFMTextEditScreenV1.this.content.size();
            while (this.displayedLineStartOffsets.size() > lines) {
                this.displayedLineStartOffsets.remove(this.displayedLineStartOffsets.size() - 1);
            }
            while (this.displayedLineStartOffsets.size() < lines) {
                this.displayedLineStartOffsets.add(SFMTextEditScreenV1.this.lastProgram.length());
            }
        }

        public void m_239213_() {
            super.m_239213_();
            ++this.cursorBlinkTick;
        }

        protected void m_239000_(PoseStack poseStack, int mx, int my, float partialTicks) {
            List<MutableComponent> lines;
            if (!SFMTextEditScreenV1.this.lastProgram.equals(this.f_238540_.m_239618_())) {
                this.rebuild(Screen.m_96637_());
            }
            if ((lines = SFMTextEditScreenV1.this.content).isEmpty()) {
                return;
            }
            boolean isCursorVisible = this.m_93696_() && this.cursorBlinkTick % 20 >= 10;
            int cursorIndex = this.f_238540_.m_239456_();
            Objects.requireNonNull(this.f_238790_);
            int lineHeight = Math.max(1, 9);
            int availableHeight = this.f_93619_ - this.m_239244_() * 2;
            double scroll = this.m_239030_();
            int viewLineIndexStart = Mth.m_14045_((int)((int)Math.floor(scroll / (double)lineHeight)), (int)0, (int)Math.max(0, lines.size() - 1));
            int numVisibleLines = Math.max(1, availableHeight / lineHeight + 2);
            int viewLineIndexEnd = Math.min(lines.size(), viewLineIndexStart + numVisibleLines);
            int lineX = SFMWidgetUtils.getX((AbstractWidget)this) + this.m_239244_() + SFMTextEditorUtils.getLineNumberWidth(this.f_238790_, SFMTextEditScreenV1.this.content.size());
            boolean isCursorAtEndOfLine = false;
            boolean drewCursorGlyph = false;
            int contentTopY = SFMWidgetUtils.getY((AbstractWidget)this) + this.m_239244_();
            int lineY = contentTopY + viewLineIndexStart * lineHeight;
            int charCountAccum = this.getLineStartIndex(viewLineIndexStart);
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.f_238540_.m_239982_();
            int selectionStart = selectedRange.f_238590_();
            int selectionEnd = selectedRange.f_238654_();
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            ArrayList<int[]> highlightRects = new ArrayList<int[]>();
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            for (int line = viewLineIndexStart; line < viewLineIndexEnd; ++line) {
                boolean cursorOnThisLine;
                MutableComponent componentColoured = lines.get(line);
                String plainLine = componentColoured.getString();
                int lineLength = plainLine.length();
                boolean bl = cursorOnThisLine = isCursorVisible && cursorIndex >= charCountAccum && cursorIndex <= charCountAccum + lineLength;
                if (SFMTextEditorUtils.shouldShowLineNumbers()) {
                    String lineNumber = String.valueOf(line + 1);
                    SFMFontUtils.drawInBatch(lineNumber, this.f_238790_, (float)(lineX - 2 - this.f_238790_.m_92895_(lineNumber)), (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCountAccum + lineLength;
                    cursorY = lineY;
                    int relativeCursorIndex = cursorIndex - charCountAccum;
                    int drawnWidthBeforeCursor = this.f_238790_.m_92895_(plainLine.substring(0, relativeCursorIndex));
                    cursorX = lineX + drawnWidthBeforeCursor;
                    SFMFontUtils.drawInBatch((Component)SFMComponentUtils.substring((Component)componentColoured, 0, relativeCursorIndex), this.f_238790_, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                    SFMTextEditScreenV1.this.suggestedActions.setXY(cursorX + 10, cursorY);
                    SFMFontUtils.drawInBatch((Component)SFMComponentUtils.substring((Component)componentColoured, relativeCursorIndex, lineLength), this.f_238790_, (float)cursorX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                    drewCursorGlyph = true;
                } else {
                    SFMFontUtils.drawInBatch((Component)componentColoured, this.f_238790_, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                if (selectionStart <= charCountAccum + lineLength && selectionEnd > charCountAccum) {
                    int lineSelectionStart = Math.max(selectionStart - charCountAccum, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCountAccum, lineLength);
                    int highlightStartX = this.f_238790_.m_92895_(plainLine.substring(0, lineSelectionStart));
                    int highlightEndX = this.f_238790_.m_92895_(plainLine.substring(0, lineSelectionEnd));
                    highlightRects.add(new int[]{lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight});
                }
                lineY += lineHeight;
                charCountAccum += lineLength + 1;
            }
            buffer.m_109911_();
            for (int[] r : highlightRects) {
                SFMScreenRenderUtils.renderHighlight(poseStack, r[0], r[1], r[2], r[3]);
            }
            if (drewCursorGlyph) {
                if (isCursorAtEndOfLine) {
                    SFMFontUtils.draw(poseStack, this.f_238790_, "_", cursorX, cursorY, -1, true);
                } else {
                    GuiComponent.m_93172_((PoseStack)poseStack, (int)cursorX, (int)(cursorY - 1), (int)(cursorX + 1), (int)(cursorY + 1 + 9), (int)-1);
                }
            }
        }
    }
}

