/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.block.BufferBlock;
import ca.teamdman.sfm.common.block.BufferBlockTier;
import ca.teamdman.sfm.common.blockentity.BufferBlockEntityContents;
import ca.teamdman.sfm.common.capability.BufferBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BufferBlockEntity
extends BlockEntity {
    private final BufferBlockEntityContents contents;
    private final ArrayList<LazyOptional<?>> toInvalidate = new ArrayList();

    public BufferBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(SFMBlockEntities.BUFFER_BLOCK_ENTITY.get(), pPos, pBlockState);
        BufferBlockTier bufferBlockTier;
        Block block = pBlockState.m_60734_();
        if (block instanceof BufferBlock) {
            BufferBlock bufferBlock = (BufferBlock)block;
            bufferBlockTier = bufferBlock.tier;
        } else {
            bufferBlockTier = BufferBlockTier.Unit;
        }
        BufferBlockTier tier = bufferBlockTier;
        this.contents = new BufferBlockEntityContents(tier);
    }

    public void invalidateCaps() {
        for (LazyOptional<?> cap : this.toInvalidate) {
            cap.invalidate();
        }
        this.toInvalidate.clear();
        super.invalidateCaps();
    }

    @MCVersionDependentBehaviour
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        SFMBlockCapabilityKind<Object> capKind = new SFMBlockCapabilityKind<Object>(cap);
        BufferBlockCapabilityProvider bufferBlockCapabilityProvider = new BufferBlockCapabilityProvider();
        assert (this.f_58857_ != null);
        SFMBlockCapabilityResult<Object> found = bufferBlockCapabilityProvider.getCapability(capKind, (LevelAccessor)this.f_58857_, this.m_58899_(), this.m_58900_(), (BlockEntity)this, side);
        if (found.isPresent()) {
            LazyOptional rtn = found.inner().lazyMap(x -> x);
            this.toInvalidate.add(rtn);
            return rtn;
        }
        return LazyOptional.empty();
    }

    public BufferBlockEntityContents getContents() {
        return this.contents;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BufferBlockEntity bufferBlockEntity) {
        if (bufferBlockEntity.getContents().lastUsedResource != state.m_61143_(BufferBlock.CONTAINED_RESOURCE)) {
            level.m_7731_(pos, (BlockState)state.m_61124_(BufferBlock.CONTAINED_RESOURCE, (Comparable)((Object)bufferBlockEntity.getContents().lastUsedResource)), 2);
        }
    }
}

