/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.common.config.SFMAIConfig;
import ca.teamdman.sfm.common.config.SFMClientConfig;
import ca.teamdman.sfm.common.config.SFMClientTextEditorConfig;
import ca.teamdman.sfm.common.config.SFMServerConfig;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class SFMConfig {
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    public static final SFMServerConfig SERVER_CONFIG;
    public static final ForgeConfigSpec CLIENT_CONFIG_SPEC;
    public static final SFMClientConfig CLIENT_CONFIG;
    public static final ForgeConfigSpec CLIENT_TEXT_EDITOR_CONFIG_SPEC;
    public static final SFMClientTextEditorConfig CLIENT_TEXT_EDITOR_CONFIG;
    public static final ForgeConfigSpec AI_CONFIG_SPEC;
    public static final SFMAIConfig AI_CONFIG;

    public static <T> T getOrDefault(ForgeConfigSpec.ConfigValue<T> configValue) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return (T)configValue.getDefault();
        }
    }

    public static <T> T getOrFallback(ForgeConfigSpec.ConfigValue<T> configValue, T fallback) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_TEXT_EDITOR_CONFIG_SPEC, "sfm-client-program-editor.toml");
        if (SFMEnvironmentUtils.isInIDE()) {
            context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AI_CONFIG_SPEC, "sfm-ai.toml");
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(SFMServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
        SERVER_CONFIG = (SFMServerConfig)pair.getLeft();
        pair = new ForgeConfigSpec.Builder().configure(SFMClientConfig::new);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT_CONFIG = (SFMClientConfig)pair.getLeft();
        pair = new ForgeConfigSpec.Builder().configure(SFMClientTextEditorConfig::new);
        CLIENT_TEXT_EDITOR_CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT_TEXT_EDITOR_CONFIG = (SFMClientTextEditorConfig)pair.getLeft();
        pair = new ForgeConfigSpec.Builder().configure(SFMAIConfig::new);
        AI_CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
        AI_CONFIG = (SFMAIConfig)pair.getLeft();
    }
}

