/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.handler;

import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.config.SFMServerConfig;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollection;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollectionKind;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentEntry;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMBlockTags;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FallingAnvilHandler {
    @SubscribeEvent
    public static void onLeave(EntityLeaveLevelEvent event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof FallingBlockEntity)) {
            return;
        }
        FallingBlockEntity fbe = (FallingBlockEntity)entity;
        if (!(fbe.m_31980_().m_60734_() instanceof AnvilBlock)) {
            return;
        }
        BlockPos anvilPos = fbe.m_20183_();
        if (!level.m_46749_(anvilPos)) {
            return;
        }
        Block blockLandedUpon = level.m_8055_(anvilPos.m_7495_()).m_60734_();
        boolean tryFormCreation = SFMBlockTags.blockHasTag(blockLandedUpon, SFMBlockTags.ANVIL_PRINTING_PRESS_FORMING);
        boolean tryCrushing = SFMBlockTags.blockHasTag(blockLandedUpon, SFMBlockTags.ANVIL_DISENCHANTING);
        if (!tryCrushing && !tryFormCreation) {
            return;
        }
        List itemEntities = level.m_45976_(ItemEntity.class, new AABB(anvilPos));
        itemEntities.removeIf(itemEntity -> !itemEntity.m_6084_() || itemEntity.m_32055_().m_41619_());
        if (tryFormCreation) {
            FallingAnvilHandler.handlePrintingPressFormCreation(level, anvilPos, itemEntities);
        } else if (tryCrushing) {
            FallingAnvilHandler.crushEnchantedBooksIntoXpShards(level, anvilPos, itemEntities);
            itemEntities.removeIf(itemEntity -> !itemEntity.m_6084_() || itemEntity.m_32055_().m_41619_());
            FallingAnvilHandler.removeEnchantmentsFromItems(level, anvilPos, itemEntities);
        }
    }

    public static int getShardCountForEnchantments(SFMServerConfig.LevelsToShards config, SFMEnchantmentCollection enchantments) {
        return switch (config) {
            default -> throw new IncompatibleClassChangeError();
            case SFMServerConfig.LevelsToShards.JustOne -> 1;
            case SFMServerConfig.LevelsToShards.EachOne -> enchantments.size();
            case SFMServerConfig.LevelsToShards.SumLevels -> {
                int sum = 0;
                for (SFMEnchantmentEntry enchantment : enchantments) {
                    sum += enchantment.level();
                }
                yield sum;
            }
            case SFMServerConfig.LevelsToShards.SumLevelsScaledExponentially -> {
                int sum = 0;
                for (SFMEnchantmentEntry enchantment : enchantments) {
                    int incr = 1 << Math.max(0, enchantment.level() - 1);
                    if (sum + incr > 0) {
                        sum += incr;
                        continue;
                    }
                    sum = Integer.MAX_VALUE;
                }
                yield sum;
            }
        };
    }

    private static void removeEnchantmentsFromItems(Level level, BlockPos anvilPos, List<ItemEntity> items) {
        ArrayList<ItemEntity> bookItemEntities = new ArrayList<ItemEntity>();
        ArrayList<ItemEntity> nonBookItemEntities = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : items) {
            if (itemEntity.m_32055_().m_150930_(Items.f_42517_)) {
                bookItemEntities.add(itemEntity);
                continue;
            }
            nonBookItemEntities.add(itemEntity);
        }
        int booksAvailable = 0;
        for (ItemEntity itemEntity : bookItemEntities) {
            int count = itemEntity.m_32055_().m_41613_();
            booksAvailable += count;
        }
        for (ItemEntity itemEntity : nonBookItemEntities) {
            ItemStack stack = itemEntity.m_32055_();
            SFMEnchantmentCollection enchantments = SFMEnchantmentCollection.fromItemStack(stack, SFMEnchantmentCollectionKind.EnchantedLikeATool);
            if (enchantments.isEmpty()) continue;
            int stackSize = stack.m_41613_();
            Iterator<SFMEnchantmentEntry> iter = enchantments.iterator();
            while (iter.hasNext() && booksAvailable >= stackSize) {
                SFMEnchantmentEntry enchantment = iter.next();
                ItemStack enchantedBookToSpawn = enchantment.createEnchantedBook();
                enchantedBookToSpawn.m_41764_(stackSize);
                level.m_7967_((Entity)new ItemEntity(level, (double)anvilPos.m_123341_(), (double)anvilPos.m_123342_(), (double)anvilPos.m_123343_(), enchantedBookToSpawn));
                iter.remove();
                enchantments.write(stack, SFMEnchantmentCollectionKind.EnchantedLikeATool);
                booksAvailable -= stackSize;
            }
        }
        for (ItemEntity itemEntity : bookItemEntities) {
            itemEntity.m_146870_();
        }
        while (booksAvailable > 0) {
            int n = Math.min(booksAvailable, 64);
            level.m_7967_((Entity)new ItemEntity(level, (double)anvilPos.m_123341_(), (double)anvilPos.m_123342_(), (double)anvilPos.m_123343_(), new ItemStack((ItemLike)Items.f_42517_, n)));
            booksAvailable -= n;
        }
    }

    private static void crushEnchantedBooksIntoXpShards(Level level, BlockPos anvilPos, List<ItemEntity> items) {
        for (ItemEntity itemEntity : items) {
            int shardStackSize;
            ItemStack stack = itemEntity.m_32055_();
            if (!stack.m_150930_(Items.f_42690_)) continue;
            SFMEnchantmentCollection enchantments = SFMEnchantmentCollection.fromItemStack(stack, SFMEnchantmentCollectionKind.HoldingLikeABook);
            long shardsForEnchantments = FallingAnvilHandler.getShardCountForEnchantments((SFMServerConfig.LevelsToShards)((Object)SFMConfig.SERVER_CONFIG.levelsToShards.get()), enchantments);
            itemEntity.m_146870_();
            for (long shardsToSpawn = (long)stack.m_41613_() * shardsForEnchantments; shardsToSpawn > 0L; shardsToSpawn -= (long)shardStackSize) {
                shardStackSize = (int)Math.min(64L, shardsToSpawn);
                ItemStack shardStack = new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get(), shardStackSize);
                ItemEntity shardItemEntity = new ItemEntity(level, (double)anvilPos.m_123341_(), (double)anvilPos.m_123342_(), (double)anvilPos.m_123343_(), shardStack);
                level.m_7967_((Entity)shardItemEntity);
            }
        }
    }

    private static void handlePrintingPressFormCreation(Level level, BlockPos anvilPos, List<ItemEntity> itemEntities) {
        List recipes = level.m_7465_().m_44013_(SFMRecipeTypes.PRINTING_PRESS.get());
        boolean consumeBlock = false;
        block0: for (ItemEntity itemEntity : itemEntities) {
            for (PrintingPressRecipe recipe : recipes) {
                if (!recipe.form().test(itemEntity.m_32055_())) continue;
                ItemStack formStack = FormItem.createFormFromReference(itemEntity.m_32055_());
                level.m_7967_((Entity)new ItemEntity(level, (double)anvilPos.m_123341_(), (double)anvilPos.m_123342_(), (double)anvilPos.m_123343_(), formStack));
                itemEntity.m_146870_();
                consumeBlock = true;
                continue block0;
            }
        }
        if (consumeBlock) {
            level.m_46597_(anvilPos.m_7495_(), Blocks.f_50016_.m_49966_());
        }
    }
}

