/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundNetworkToolUsePacket;
import ca.teamdman.sfm.common.registry.SFMCreativeTabs;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.CompressedBlockPosSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NetworkToolItem
extends Item {
    public NetworkToolItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(SFMCreativeTabs.TAB));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext pContext) {
        if (!pContext.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        SFMPackets.sendToServer(new ServerboundNetworkToolUsePacket(pContext.m_8083_(), pContext.m_43719_()));
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag detail) {
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_1.getComponent().m_130940_(ChatFormatting.GRAY));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_2.getComponent().m_130940_(ChatFormatting.GRAY));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_3.getComponent(((KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get()).m_90863_()).m_130940_(ChatFormatting.AQUA));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_4.getComponent().m_130940_(ChatFormatting.LIGHT_PURPLE));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_5.getComponent().m_130940_(ChatFormatting.LIGHT_PURPLE));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_6.getComponent().m_130940_(ChatFormatting.LIGHT_PURPLE));
        lines.add((Component)LocalizationKeys.NETWORK_TOOL_ITEM_TOOLTIP_7.getComponent().m_130940_(ChatFormatting.LIGHT_PURPLE));
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        boolean shouldRefresh;
        boolean isInHand;
        if (pLevel.f_46443_) {
            return;
        }
        if (!(pEntity instanceof Player)) {
            return;
        }
        Player pPlayer = (Player)pEntity;
        boolean bl = isInHand = pStack == pPlayer.m_21205_() || pStack == pPlayer.m_21206_();
        if (!isInHand) {
            return;
        }
        boolean bl2 = shouldRefresh = pEntity.f_19797_ % 20 == 0;
        if (!shouldRefresh) {
            return;
        }
        long maxDistance = 128L;
        Set<BlockPos> cablePositions = CableNetworkManager.getNetworksInRange(pLevel, pEntity.m_20183_(), 128.0).flatMap(CableNetwork::getCablePositions).collect(Collectors.toSet());
        NetworkToolItem.setCablePositions(pStack, cablePositions);
        Set<BlockPos> capabilityProviderPositions = CableNetworkManager.getNetworksInRange(pLevel, pEntity.m_20183_(), 128.0).flatMap(CableNetwork::getCapabilityProviderPositions).collect(Collectors.toSet());
        NetworkToolItem.setCapabilityProviderPositions(pStack, capabilityProviderPositions);
        pStack.m_41784_().m_128473_("networks");
    }

    public static boolean getOverlayEnabled(ItemStack stack) {
        return !stack.m_41784_().m_128471_("sfm:network_tool_overlay_disabled");
    }

    public static void setOverlayEnabled(ItemStack stack, boolean value) {
        if (value) {
            stack.m_41784_().m_128473_("sfm:network_tool_overlay_disabled");
        } else {
            stack.m_41784_().m_128379_("sfm:network_tool_overlay_disabled", true);
        }
    }

    public static void setCablePositions(ItemStack stack, Set<BlockPos> positions) {
        stack.m_41784_().m_128365_("sfm:cable_positions", (Tag)CompressedBlockPosSet.from(positions).asTag());
    }

    public static Set<BlockPos> getCablePositions(ItemStack stack) {
        Tag tag = stack.m_41784_().m_128423_("sfm:cable_positions");
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            return CompressedBlockPosSet.from(byteArrayTag).into();
        }
        return stack.m_41784_().m_128437_("sfm:cable_positions", 10).stream().map(CompoundTag.class::cast).map(NbtUtils::m_129239_).collect(Collectors.toSet());
    }

    public static void setCapabilityProviderPositions(ItemStack stack, Set<BlockPos> positions) {
        stack.m_41784_().m_128365_("sfm:capability_provider_positions", (Tag)CompressedBlockPosSet.from(positions).asTag());
    }

    public static Set<BlockPos> getCapabilityProviderPositions(ItemStack stack) {
        Tag tag = stack.m_41784_().m_128423_("sfm:capability_provider_positions");
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            return CompressedBlockPosSet.from(byteArrayTag).into();
        }
        return stack.m_41784_().m_128437_("sfm:capability_provider_positions", 10).stream().map(CompoundTag.class::cast).map(NbtUtils::m_129239_).collect(Collectors.toSet());
    }
}

