/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.config.SFMConfig;
import java.util.HashSet;
import net.minecraft.network.chat.contents.TranslatableContents;

public record ProblemTracker(HashSet<TranslatableContents> problems) {
    public ProblemTracker() {
        this(new HashSet<TranslatableContents>());
    }

    public AddProblemResult add(TranslatableContents problem) {
        int size = this.problems.size();
        if (size >= (Integer)SFMConfig.SERVER_CONFIG.maxDiskProblems.get()) {
            return AddProblemResult.TOO_MANY_PROBLEMS;
        }
        this.problems.add(problem);
        if (size < (Integer)SFMConfig.SERVER_CONFIG.maxDiskProblems.get()) {
            return AddProblemResult.SUCCESS;
        }
        return AddProblemResult.TOO_MANY_PROBLEMS;
    }

    public boolean isSaturated() {
        return this.problems.size() >= (Integer)SFMConfig.SERVER_CONFIG.maxDiskProblems.get();
    }

    public int size() {
        return this.problems.size();
    }

    public static enum AddProblemResult {
        SUCCESS,
        TOO_MANY_PROBLEMS;


        public boolean isSaturated() {
            return this == TOO_MANY_PROBLEMS;
        }
    }
}

