/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfm.common.program.linting.ProblemTracker;
import ca.teamdman.sfm.common.registry.SFMProgramLinters;
import ca.teamdman.sfml.ast.Program;
import java.util.Collection;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ProgramLinter {
    public static Collection<TranslatableContents> gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity manager) {
        ProblemTracker tracker = new ProblemTracker();
        for (IProgramLinter linter : SFMProgramLinters.registry().values()) {
            linter.gatherWarnings(program, labelPositionHolder, manager, tracker);
            if (!tracker.isSaturated()) continue;
            break;
        }
        return tracker.problems();
    }

    public static void fixWarnings(ManagerBlockEntity manager, ItemStack disk, Program program) {
        LabelPositionHolder labels = LabelPositionHolder.from(disk);
        for (IProgramLinter linter : SFMProgramLinters.registry().values()) {
            assert (manager.m_58904_() != null);
            linter.fixWarnings(program, labels, manager, manager.m_58904_(), disk);
        }
        manager.rebuildProgramAndUpdateDisk();
    }
}

