/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting.compat.mekanism;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfm.common.program.linting.ProblemTracker;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.Side;
import ca.teamdman.sfml.ast.SideQualifier;
import com.mojang.datafixers.util.Pair;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.RelativeSide;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MekanismSidednessProgramLinter
implements IProgramLinter {
    @Override
    public void gatherWarnings(Program program, LabelPositionHolder labels, @Nullable ManagerBlockEntity manager, ProblemTracker tracker) {
        if (manager == null) {
            return;
        }
        Level level = manager.m_58904_();
        if (level == null) {
            return;
        }
        Stream<IOStatement> ioStatements = program.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast);
        for (IOStatement statement : SFMStreamUtils.iterate(ioStatements)) {
            if (MekanismSidednessProgramLinter.gatherWarningsForIOStatement(statement, labels, statement, level, tracker).isSaturated()) break;
        }
    }

    @Override
    public void fixWarnings(Program program, LabelPositionHolder labels, ManagerBlockEntity manager, Level level, ItemStack disk) {
        program.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).forEach(statement -> MekanismSidednessProgramLinter.fixWarningsByModifyingMekanismAccess(statement, LabelPositionHolder.from(disk), level));
    }

    private static ProblemTracker.AddProblemResult gatherWarningsForIOStatement(IOStatement ioStatement, LabelPositionHolder labelPositionHolder, IOStatement statement, Level level, ProblemTracker warnings) {
        SideQualifier sides = statement.labelAccess().sides();
        Stream<Pair> mekanismBlocks = statement.labelAccess().getLabelledPositions(labelPositionHolder).stream().filter(pair -> level.m_46749_((BlockPos)pair.getSecond())).filter(pair -> SFMModCompat.isMekanismBlock(level, (BlockPos)pair.getSecond()));
        if (sides.sides().contains(Side.NULL)) {
            for (Pair pair2 : SFMStreamUtils.iterate(mekanismBlocks)) {
                Label label = (Label)pair2.getFirst();
                if (!warnings.add(LocalizationKeys.PROGRAM_WARNING_MEKANISM_USED_WITH_NULL_DIRECTION.get(label, statement.toStringPretty())).isSaturated()) continue;
                return ProblemTracker.AddProblemResult.TOO_MANY_PROBLEMS;
            }
        } else {
            Predicate<DataType> dataTypePredicate;
            EnumSet<TransmissionType> referencedTransmissionTypes = SFMMekanismCompat.getReferencedTransmissionTypes(statement);
            if (ioStatement instanceof InputStatement) {
                dataTypePredicate = dataType -> dataType.canOutput() || dataType == DataType.EXTRA;
            } else if (ioStatement instanceof OutputStatement) {
                dataTypePredicate = dataType -> dataType == DataType.INPUT || dataType == DataType.INPUT_OUTPUT || dataType == DataType.INPUT_1 || dataType == DataType.INPUT_2 || dataType == DataType.EXTRA;
            } else {
                throw new IllegalStateException("Unexpected value: " + ioStatement);
            }
            mekanismBlocks.forEach(pair -> {
                BlockPos blockPos = (BlockPos)pair.getSecond();
                BlockEntity blockEntity = level.m_7702_(blockPos);
                if (blockEntity instanceof ISideConfiguration) {
                    ISideConfiguration mekBlockEntity = (ISideConfiguration)blockEntity;
                    TileComponentConfig config = mekBlockEntity.getConfig();
                    BlockState blockState = blockEntity.m_58900_();
                    for (TransmissionType transmissionType : referencedTransmissionTypes) {
                        boolean anySuccess = false;
                        ConfigInfo transmissionConfig = config.getConfig(transmissionType);
                        if (transmissionConfig != null) {
                            Set activeSides = transmissionConfig.getSides(dataTypePredicate);
                            for (Direction direction : sides.resolve(blockState)) {
                                if (!activeSides.contains(direction)) continue;
                                anySuccess = true;
                                break;
                            }
                        }
                        if (anySuccess) continue;
                        warnings.add(LocalizationKeys.PROGRAM_WARNING_MEKANISM_BAD_SIDE_CONFIG.get(blockPos, pair.getFirst(), statement.toStringPretty()));
                    }
                }
            });
        }
        return ProblemTracker.AddProblemResult.SUCCESS;
    }

    private static void fixWarningsByModifyingMekanismAccess(IOStatement statement, LabelPositionHolder labelPositionHolder, Level level) {
        DataType fixed;
        Predicate<DataType> dataTypePredicate;
        SideQualifier sides = statement.labelAccess().sides();
        Stream<Pair> mekanismBlocks = statement.labelAccess().getLabelledPositions(labelPositionHolder).stream().filter(pair -> level.m_46749_((BlockPos)pair.getSecond())).filter(pair -> SFMModCompat.isMekanismBlock(level, (BlockPos)pair.getSecond()));
        EnumSet<TransmissionType> referencedTransmissionTypes = SFMMekanismCompat.getReferencedTransmissionTypes(statement);
        if (statement instanceof InputStatement) {
            dataTypePredicate = DataType::canOutput;
            fixed = DataType.OUTPUT;
        } else if (statement instanceof OutputStatement) {
            dataTypePredicate = dataType -> dataType == DataType.INPUT || dataType == DataType.INPUT_OUTPUT || dataType == DataType.INPUT_1 || dataType == DataType.INPUT_2;
            fixed = DataType.INPUT;
        } else {
            throw new IllegalStateException("Unexpected value: " + statement);
        }
        mekanismBlocks.forEach(pair -> {
            BlockPos blockPos = (BlockPos)pair.getSecond();
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof ISideConfiguration) {
                ISideConfiguration mekBlockEntity = (ISideConfiguration)blockEntity;
                TileComponentConfig mekBlockEntityConfig = mekBlockEntity.getConfig();
                BlockState blockState = blockEntity.m_58900_();
                HashSet<@Nullable Direction> directions = new HashSet<Direction>(sides.resolve(blockState));
                for (TransmissionType transmissionType : referencedTransmissionTypes) {
                    Direction directionToEnable;
                    ConfigInfo transmissionConfig = mekBlockEntityConfig.getConfig(transmissionType);
                    if (transmissionConfig == null) continue;
                    Set<Direction> activeSides = SFMMekanismCompat.getSides(transmissionConfig, mekBlockEntity, dataTypePredicate);
                    boolean anySuccess = directions.stream().anyMatch(activeSides::contains);
                    if (anySuccess || (directionToEnable = sides.getNonNullDirection(blockState)) == null) continue;
                    RelativeSide relativeSide = RelativeSide.fromDirections((Direction)mekBlockEntity.getDirection(), (Direction)directionToEnable);
                    transmissionConfig.setDataType(fixed, new RelativeSide[]{relativeSide});
                    mekBlockEntityConfig.sideChanged(transmissionType, relativeSide);
                }
            }
        });
    }
}

