/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.registry.SFMDeferredRegister;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public class SFMDeferredRegisterBuilder<T> {
    @Nullable
    public ResourceKey<? extends Registry<T>> registryKey = null;
    public boolean createNewRegistry;
    public BooleanSupplier onlyIf = () -> true;
    @Nullable
    public String namespace;

    public SFMDeferredRegisterBuilder<T> registry(ResourceKey<? extends Registry<T>> registryKey) {
        this.registryKey = registryKey;
        return this;
    }

    public SFMDeferredRegisterBuilder<T> namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public SFMDeferredRegisterBuilder<T> createNewRegistry() {
        this.createNewRegistry = true;
        return this;
    }

    public SFMDeferredRegisterBuilder<T> onlyIf(BooleanSupplier condition) {
        this.onlyIf = condition;
        return this;
    }

    @MCVersionDependentBehaviour
    public SFMDeferredRegister<T> build() {
        DeferredRegister inner;
        if (this.registryKey == null) {
            throw new IllegalStateException("Registry key must be set!");
        }
        if (this.namespace == null) {
            throw new IllegalStateException("Namespace must be set!");
        }
        boolean enabled = this.onlyIf.getAsBoolean();
        if (SFMEnvironmentUtils.isInIDE()) {
            SFM.LOGGER.debug("Creating registry {}, enabled={}", this.registryKey, (Object)enabled);
        }
        if (enabled) {
            inner = DeferredRegister.create(this.registryKey, (String)"sfm");
            if (this.createNewRegistry) {
                inner.makeRegistry(() -> new RegistryBuilder().setName(this.registryKey.m_135782_()));
            }
        } else {
            inner = null;
        }
        return new SFMDeferredRegister(this.registryKey, this.namespace, inner);
    }
}

