/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.block.BufferBlock;
import ca.teamdman.sfm.common.blockentity.BufferBlockEntityContents;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.resourcetype.ScalarResourceType;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import java.util.List;
import java.util.stream.Stream;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.Nullable;

public class MekanismEnergyResourceType
extends ScalarResourceType<FloatingLong, IStrictEnergyHandler> {
    public static final SFMBlockCapabilityKind<IStrictEnergyHandler> CAP = new SFMBlockCapabilityKind(CapabilityManager.get((CapabilityToken)new CapabilityToken<IStrictEnergyHandler>(){}));

    public MekanismEnergyResourceType() {
        super(CAP, SFMResourceLocation.fromNamespaceAndPath("mekanism", "energy"), FloatingLong.class);
    }

    @Override
    public IStrictEnergyHandler createHandlerForBufferBlock(final BufferBlockEntityContents contents) {
        return new IMekanismStrictEnergyHandler(){
            private final List<IEnergyContainer> containers;
            {
                this.containers = List.of(BasicEnergyContainer.create((FloatingLong)FloatingLong.create((long)contents.tier.getLongScalarMaxStackSize()), null));
            }

            public List<IEnergyContainer> getEnergyContainers(@Nullable Direction direction) {
                return this.containers;
            }

            public FloatingLong insertEnergy(int container, FloatingLong amount, @Nullable Direction side, Action action) {
                boolean canReceive;
                boolean bl = canReceive = !this.getEnergy(0).isZero() || contents.isEmpty();
                if (!canReceive) {
                    return amount;
                }
                if (action.execute() && contents.isEmpty()) {
                    contents.lastUsedResource = BufferBlock.ContainedResource.Energy;
                }
                return super.insertEnergy(container, amount, side, action);
            }

            public void onContentsChanged() {
            }
        };
    }

    @Override
    public long getAmount(FloatingLong amount) {
        return amount.longValue();
    }

    @Override
    public long getAmountDifference(FloatingLong stack1, FloatingLong stack2) {
        return stack1.subtract(stack2).longValue();
    }

    @Override
    public FloatingLong getStackInSlot(IStrictEnergyHandler storage, int slot) {
        return storage.getEnergy(slot);
    }

    @Override
    public FloatingLong extract(IStrictEnergyHandler storage, int slot, long amount, boolean simulate) {
        return storage.extractEnergy(FloatingLong.create((long)amount), simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public int getSlots(IStrictEnergyHandler handler) {
        return 1;
    }

    @Override
    public long getMaxStackSize(FloatingLong stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMaxStackSizeForSlot(IStrictEnergyHandler storage, int slot) {
        return storage.getMaxEnergy(slot).longValue();
    }

    @Override
    public FloatingLong insert(IStrictEnergyHandler storage, int slot, FloatingLong amount, boolean simulate) {
        FloatingLong remainder = storage.insertEnergy(amount, simulate ? Action.SIMULATE : Action.EXECUTE);
        return remainder;
    }

    @Override
    public boolean isEmpty(FloatingLong stack) {
        return stack.isZero();
    }

    @Override
    public boolean matchesCapabilityHandler(Object o) {
        return o instanceof IStrictEnergyHandler;
    }

    @Override
    public Stream<ResourceLocation> getTagsForStack(FloatingLong floatingLong) {
        return Stream.empty();
    }

    @Override
    public FloatingLong getEmptyStack() {
        return FloatingLong.ZERO;
    }

    @Override
    public FloatingLong copy(FloatingLong stack) {
        return stack;
    }

    @Override
    public FloatingLong withCount(FloatingLong floatingLong, long count) {
        return FloatingLong.create((long)count);
    }

    @Override
    protected FloatingLong setCount(FloatingLong stack, long amount) {
        return FloatingLong.create((long)amount);
    }
}

