/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.ExecuteProgramBehaviour;
import ca.teamdman.sfm.common.program.LimitedInputSlotObjectPool;
import ca.teamdman.sfm.common.program.LimitedOutputSlotObjectPool;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfm.common.timing.SFMInstant;
import ca.teamdman.sfml.ast.ASTBuilder;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.ToStringCondensed;
import ca.teamdman.sfml.ast.Trigger;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.level.Level;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.jetbrains.annotations.NotNull;

public record Program(ASTBuilder astBuilder, String name, List<Trigger> triggers, Set<String> referencedLabels, Set<ResourceIdentifier<?, ?, ?>> referencedResources) implements Statement
{
    public static final int MAX_PROGRAM_LENGTH = 32367;
    public static final int MAX_LABEL_LENGTH = 256;

    public boolean tick(ManagerBlockEntity manager) {
        ProgramContext context = new ProgramContext(this, manager, new ExecuteProgramBehaviour());
        int unprocessedRedstonePulseCount = manager.getUnprocessedRedstonePulseCount();
        if (unprocessedRedstonePulseCount > 0) {
            manager.logger.debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_WITH_REDSTONE_COUNT.get(unprocessedRedstonePulseCount)));
        }
        this.tick(context);
        manager.clearRedstonePulseQueue();
        return context.didSomething();
    }

    @Override
    public List<Statement> getStatements() {
        return this.triggers;
    }

    @Override
    public void tick(ProgramContext context) {
        LimitedInputSlotObjectPool.checkInvariant();
        LimitedOutputSlotObjectPool.checkInvariant();
        for (Trigger trigger : this.triggers) {
            List<Trigger> list;
            if (!trigger.shouldTick(context)) continue;
            if (!context.didSomething()) {
                context.setDidSomething(true);
                context.getLogger().trace(Program.getTraceLogWriter(context));
                context.getLogger().debug(debug -> debug.accept(LocalizationKeys.LOG_PROGRAM_TICK.get()));
            }
            if ((list = this.triggers) instanceof ToStringCondensed) {
                ToStringCondensed ss = (ToStringCondensed)((Object)list);
                context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_TRIGGER_STATEMENT.get(ss.toStringCondensed())));
            }
            SFMInstant start = SFMInstant.now();
            ProgramBehaviour programBehaviour = context.getBehaviour();
            if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
                SimulateExploreAllPathsProgramBehaviour simulation = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
                int maxConditionCount = (Integer)SFMConfig.getOrDefault(SFMConfig.SERVER_CONFIG.maxIfStatementsInTriggerBeforeSimulationIsntAllowed);
                int conditionCount = trigger.getConditionCount();
                if (conditionCount <= maxConditionCount) {
                    int numPossibleStates = (int)Math.max(1.0, Math.pow(2.0, conditionCount));
                    for (int i = 0; i < numPossibleStates; ++i) {
                        ProgramContext forkedContext = context.fork();
                        trigger.tick(forkedContext);
                        forkedContext.free();
                        ((SimulateExploreAllPathsProgramBehaviour)forkedContext.getBehaviour()).terminatePathAndBeginAnew();
                    }
                } else {
                    context.getLogger().warn(LocalizationKeys.PROGRAM_WARNING_TOO_MANY_CONDITIONS.get(trigger.toString(), conditionCount, maxConditionCount));
                }
                simulation.prepareNextTrigger();
            } else {
                ProgramContext forkedContext = context.fork();
                trigger.tick(forkedContext);
                forkedContext.free();
            }
            Duration elapsed = start.elapsed();
            context.getLogger().info(x -> x.accept(LocalizationKeys.PROGRAM_TICK_TRIGGER_TIME_MS.get(elapsed.toMillis(), trigger.toString())));
        }
        LimitedInputSlotObjectPool.checkInvariant();
        LimitedOutputSlotObjectPool.checkInvariant();
        ProgramBehaviour programBehaviour = context.getBehaviour();
        if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
            SimulateExploreAllPathsProgramBehaviour simulation = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
            simulation.onProgramFinished(context, this);
        }
    }

    public int getConditionIndex(IfStatement ifStatement) {
        for (Trigger trigger : this.triggers) {
            int conditionIndex = trigger.getConditionIndex(ifStatement);
            if (conditionIndex == -1) continue;
            return conditionIndex;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder rtn = new StringBuilder();
        rtn.append("NAME \"").append(this.name).append("\"\n");
        for (Trigger trigger : this.triggers) {
            rtn.append(trigger).append("\n");
        }
        return rtn.toString();
    }

    public void replaceOutputStatement(OutputStatement oldStatement, OutputStatement newStatement) {
        if (!ProgramBuilder.isMutationAllowed(this)) {
            throw new IllegalArgumentException("Mutation is not allowed on this Program object because it is cached! Program = " + this);
        }
        ArrayDeque<Statement> toPatch = new ArrayDeque<Statement>();
        toPatch.add(this);
        while (!toPatch.isEmpty()) {
            Statement statement = (Statement)toPatch.pollFirst();
            List<Statement> children = statement.getStatements();
            for (int i = 0; i < children.size(); ++i) {
                Statement child = children.get(i);
                if (child == oldStatement) {
                    children.set(i, newStatement);
                    continue;
                }
                toPatch.add(child);
            }
        }
    }

    @NotNull
    private static Consumer<Consumer<TranslatableContents>> getTraceLogWriter(ProgramContext context) {
        return trace -> {
            trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_HEADER_1.get());
            trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_HEADER_2.get());
            Level level = context.getManager().m_58904_();
            context.getNetwork().getCablePositions().map(pos -> "- " + pos.toString() + " " + level.m_8055_(pos)).forEach(body -> trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_BODY.get(body)));
            trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_HEADER_3.get());
            context.getNetwork().getCapabilityProviderPositions().map(pos -> "- " + pos.toString() + " " + level.m_8055_(pos)).forEach(body -> trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_BODY.get(body)));
            trace.accept(LocalizationKeys.LOG_CABLE_NETWORK_DETAILS_FOOTER.get());
            trace.accept(LocalizationKeys.LOG_LABEL_POSITION_HOLDER_DETAILS_HEADER.get());
            context.getLabelPositionHolder().labels().forEach((label, positions) -> positions.stream().map(pos -> "- " + label + ": " + pos.toString() + " " + level.m_8055_(pos)).forEach(body -> trace.accept(LocalizationKeys.LOG_LABEL_POSITION_HOLDER_DETAILS_BODY.get(body))));
            trace.accept(LocalizationKeys.LOG_LABEL_POSITION_HOLDER_DETAILS_FOOTER.get());
            trace.accept(LocalizationKeys.LOG_PROGRAM_CONTEXT.get(context.toString()));
        };
    }

    public static class ListErrorListener
    extends BaseErrorListener {
        private final List<String> errors;

        public ListErrorListener(List<String> errors) {
            this.errors = errors;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.errors.add("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

