/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.widget;

import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.screen.SFMWidgetUtils;
import ca.teamdman.sfm.client.widget.PickListItem;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.simmetrics.StringDistance;
import org.simmetrics.builders.StringDistanceBuilder;
import org.simmetrics.metrics.StringDistances;
import org.simmetrics.simplifiers.Simplifiers;

public class PickList<T extends PickListItem>
extends AbstractScrollWidget {
    protected final Font font;
    protected List<T> items;
    protected int selectionIndex = -1;
    protected Component query = Component.m_237119_();

    public PickList(Font font, int pX, int pY, int pWidth, int pHeight, Component title, List<T> items) {
        super(pX, pY, pWidth, pHeight, title);
        this.font = font;
        this.items = items;
        this.clampOrUnsetSelectionIndex();
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
        this.sortItems();
        this.selectionIndex = 0;
        this.clampOrUnsetSelectionIndex();
        this.scrollSelectedIntoView();
    }

    public int getItemHeight() {
        Objects.requireNonNull(this.font);
        return 9;
    }

    @Nullable
    public T getSelected() {
        if (this.items.isEmpty()) {
            return null;
        }
        if (this.selectionIndex < 0) {
            return null;
        }
        if (this.selectionIndex >= this.items.size()) {
            return null;
        }
        return (T)((PickListItem)this.getItems().get(this.selectionIndex));
    }

    public void setQuery(Component query) {
        this.query = query;
        this.sortItems();
        this.selectionIndex = 0;
        this.clampOrUnsetSelectionIndex();
        this.scrollSelectedIntoView();
    }

    @MCVersionDependentBehaviour
    public void setXY(int x, int y) {
        this.m_252865_(x);
        this.m_253211_(y);
    }

    @MCVersionDependentBehaviour
    protected void m_168797_(NarrationElementOutput narration) {
        narration.m_169146_(NarratedElementType.TITLE, this.m_6035_());
    }

    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.items.isEmpty()) {
            return;
        }
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void selectPreviousWrapping() {
        if (this.selectionIndex == -1) {
            this.selectionIndex = this.items.size() - 1;
            return;
        }
        this.selectionIndex = (this.selectionIndex - 1 + this.items.size()) % this.items.size();
        this.scrollSelectedIntoView();
    }

    public void selectNextWrapping() {
        if (this.selectionIndex == -1) {
            this.selectionIndex = 0;
            return;
        }
        this.selectionIndex = (this.selectionIndex + 1) % this.items.size();
        this.scrollSelectedIntoView();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void clear() {
        this.items.clear();
        this.selectionIndex = -1;
    }

    private void clampOrUnsetSelectionIndex() {
        this.selectionIndex = this.items.isEmpty() ? -1 : Mth.m_14045_((int)this.selectionIndex, (int)0, (int)(this.items.size() - 1));
    }

    private void scrollSelectedIntoView() {
        if (this.isEmpty()) {
            this.m_240206_(0.0);
        } else {
            this.m_240206_((float)(this.selectionIndex * this.getItemHeight()) - (float)this.f_93619_ / 2.0f + (float)this.getItemHeight());
        }
    }

    private void sortItems() {
        StringDistance distance = StringDistanceBuilder.with(StringDistances.jaroWinkler()).simplify(Simplifiers.toLowerCase()).build();
        String queryString = this.query.getString();
        if (queryString.isBlank()) {
            String[] preferredOrder = new String[]{"TICKS", "INPUT", "OUTPUT", "FORGET", "FROM", "TO"};
            this.items.sort(Comparator.comparing(item -> {
                String itemString = item.getComponent().getString();
                for (int i = 0; i < preferredOrder.length; ++i) {
                    if (!itemString.contains(preferredOrder[i])) continue;
                    return i;
                }
                return preferredOrder.length;
            }));
        } else {
            this.items.sort(Comparator.comparing(item -> Float.valueOf(distance.distance(item.getComponent().getString(), queryString))));
        }
    }

    protected int m_239019_() {
        return this.getItemHeight() * this.items.size();
    }

    protected boolean m_239656_() {
        return (double)this.items.size() > this.getDisplayableItemCount();
    }

    private double getDisplayableItemCount() {
        return (double)(this.f_93619_ - this.m_240012_()) / (double)this.getItemHeight();
    }

    protected double m_239725_() {
        return (double)this.getItemHeight() / 2.0;
    }

    protected void m_239197_(GuiGraphics graphics, int mx, int my, float partialTick) {
        if (this.items.isEmpty()) {
            return;
        }
        int itemHeight = this.getItemHeight();
        int startIndex = (int)(this.m_239030_() / (double)itemHeight);
        int visibleCount = (int)Math.ceil((double)this.f_93619_ / (double)itemHeight) + 1;
        int endIndex = Math.min(this.items.size(), startIndex + visibleCount);
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int lineX = SFMWidgetUtils.getX((AbstractWidget)this) + this.m_239244_();
        Rect2i highlight = null;
        for (int i = startIndex; i < endIndex; ++i) {
            PickListItem item = (PickListItem)this.items.get(i);
            int lineY = SFMWidgetUtils.getY((AbstractWidget)this) + this.m_239244_() + i * itemHeight;
            SFMFontUtils.drawInBatch(item.getComponent(), this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
            if (i != this.selectionIndex) continue;
            highlight = new Rect2i(lineX, lineY, this.f_93618_, itemHeight);
        }
        buffer.m_109911_();
        if (highlight != null) {
            SFMScreenRenderUtils.renderHighlight(graphics, highlight.m_110085_(), highlight.m_110086_(), highlight.m_110085_() + highlight.m_110090_(), highlight.m_110086_() + highlight.m_110091_());
        }
    }
}

