/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.event_bus;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.event_bus.SFMEventListenerMethod;
import ca.teamdman.sfm.common.event_bus.SFMSubscribeEvent;
import ca.teamdman.sfm.common.util.SFMAnnotationUtils;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.objectweb.asm.Type;

public class SFMAutomaticEventSubscriber {
    public static void attachEventBusSubscribers() {
        SFMAnnotationUtils.discoverAnnotations(SFMSubscribeEvent.class).filter(annotationData -> {
            EnumSet<Dist> sides = annotationData.getEnumSet("value", Dist.class);
            if (sides.isEmpty()) {
                sides.add(SFMEnvironmentUtils.CLIENT_DIST);
                sides.add(SFMEnvironmentUtils.SERVER_DIST);
            }
            Dist currentDist = FMLEnvironment.dist;
            return sides.contains(currentDist);
        }).forEach(SFMAutomaticEventSubscriber::tryRegisterAnnotatedMethod);
    }

    private static void tryRegisterAnnotatedMethod(SFMAnnotationUtils.SFMAnnotationData annotationData) {
        Class<?> handlerMethodParentClass = SFMAnnotationUtils.tryLoadAnnotatedClass(annotationData);
        String methodDisplay = handlerMethodParentClass.getName() + "#" + annotationData.memberName();
        Method found = null;
        for (Method method : handlerMethodParentClass.getDeclaredMethods()) {
            String methodName = method.getName() + Type.getMethodDescriptor((Method)method);
            if (!methodName.equals(annotationData.memberName())) continue;
            found = method;
            break;
        }
        if (found == null) {
            SFM.LOGGER.error("Unable to register event subscriber, failed to find method {}", (Object)methodDisplay);
            return;
        }
        Method handlerMethod = found;
        SFM.LOGGER.debug("Registering event subscriber {}", (Object)methodDisplay);
        if (!Modifier.isStatic(handlerMethod.getModifiers())) {
            throw new IllegalArgumentException("Event subscriber method must be static: " + methodDisplay);
        }
        SFMSubscribeEvent annotation = handlerMethod.getAnnotation(SFMSubscribeEvent.class);
        if (annotation == null) {
            throw new IllegalStateException("Event subscriber method somehow missing @SFMSubscribeEvent annotation: " + methodDisplay);
        }
        SFMEventListenerMethod<?> eventListener = SFMEventListenerMethod.forStaticMethod(handlerMethodParentClass, handlerMethod, annotationData, annotation);
        eventListener.register();
    }
}

