/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IInputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceLimit;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class ExpandedQuantityExpandedRetentionInputResourceTracker
implements IInputResourceTracker {
    private final ResourceLimit resource_limit;
    private final ResourceIdSet exclusions;
    private final Long2ObjectOpenHashMap<Int2ObjectArrayMap<Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>>>> retention_obligations_by_pos_by_slot_by_item = new Long2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>> retention_obligations_by_item = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<ResourceType<?, ?, ?>, Object2LongOpenHashMap<ResourceLocation>> transferred_by_item = new Object2ObjectOpenHashMap();

    public ExpandedQuantityExpandedRetentionInputResourceTracker(ResourceLimit resourceLimit, ResourceIdSet exclusions) {
        this.resource_limit = resourceLimit;
        this.exclusions = exclusions;
    }

    @Override
    public <STACK, CAP, ITEM> boolean isDone(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        long can_transfer = this.resource_limit.limit().quantity().number().value();
        long transferred_for_item = 0L;
        Object2LongOpenHashMap transferred_for_resource_type = (Object2LongOpenHashMap)this.transferred_by_item.get(type);
        if (transferred_for_resource_type != null) {
            ResourceLocation item_id = type.getRegistryKeyForStack(stack);
            transferred_for_item = transferred_for_resource_type.getLong((Object)item_id);
        }
        return transferred_for_item >= can_transfer;
    }

    @Override
    public ResourceLimit getResourceLimit() {
        return this.resource_limit;
    }

    @Override
    public ResourceIdSet getExclusions() {
        return this.exclusions;
    }

    @Override
    public <STACK, ITEM, CAP> long getRetentionObligationForSlot(ResourceType<STACK, ITEM, CAP> resourceType, STACK key, @NotStored BlockPos pos, int slot) {
        Object2ObjectOpenHashMap resourceTypeEntry;
        Int2ObjectArrayMap posEntry = (Int2ObjectArrayMap)this.retention_obligations_by_pos_by_slot_by_item.get(pos.m_121878_());
        if (posEntry != null && (resourceTypeEntry = (Object2ObjectOpenHashMap)posEntry.get(slot)) != null) {
            ResourceLocation item_id = resourceType.getRegistryKeyForStack(key);
            Object2LongOpenHashMap itemEntry = (Object2LongOpenHashMap)resourceTypeEntry.get(resourceType);
            if (itemEntry != null) {
                return itemEntry.getLong((Object)item_id);
            }
        }
        return 0L;
    }

    @Override
    public <STACK, ITEM, CAP> long getRemainingRetentionObligation(ResourceType<STACK, ITEM, CAP> resourceType, STACK key) {
        ResourceLocation item_id;
        long retention = this.resource_limit.limit().retention().number().value();
        long retained_for_item = 0L;
        Object2LongOpenHashMap retained_for_resource_type = (Object2LongOpenHashMap)this.retention_obligations_by_item.get(resourceType);
        if (retained_for_resource_type != null && retained_for_resource_type.containsKey((Object)(item_id = resourceType.getRegistryKeyForStack(key)))) {
            retained_for_item = retained_for_resource_type.getLong((Object)item_id);
        }
        return retention - retained_for_item;
    }

    @Override
    public <STACK, ITEM, CAP> void trackRetentionObligation(ResourceType<STACK, ITEM, CAP> resourceType, STACK key, int slot, @NotStored BlockPos pos, long dedicatingToObligation) {
        ResourceLocation item_id = resourceType.getRegistryKeyForStack(key);
        ((Object2LongOpenHashMap)this.retention_obligations_by_item.computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, dedicatingToObligation);
        ((Object2LongOpenHashMap)((Object2ObjectOpenHashMap)((Int2ObjectArrayMap)this.retention_obligations_by_pos_by_slot_by_item.computeIfAbsent(pos.m_121878_(), k -> new Int2ObjectArrayMap())).computeIfAbsent(slot, k -> new Object2ObjectOpenHashMap())).computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, dedicatingToObligation);
    }

    @Override
    public <STACK, ITEM, CAP> long getMaxTransferable(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack) {
        long max_transfer = this.resource_limit.limit().quantity().number().value();
        long transferred_for_item = 0L;
        Object2LongOpenHashMap transferred_for_resource_type = (Object2LongOpenHashMap)this.transferred_by_item.get(resourceType);
        if (transferred_for_resource_type != null) {
            ResourceLocation item_id = resourceType.getRegistryKeyForStack(stack);
            transferred_for_item = transferred_for_resource_type.getLong((Object)item_id);
        }
        return max_transfer - transferred_for_item;
    }

    @Override
    public <STACK, ITEM, CAP> void trackTransfer(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, long amount) {
        ResourceLocation item_id = resourceType.getRegistryKeyForStack(stack);
        ((Object2LongOpenHashMap)this.transferred_by_item.computeIfAbsent(resourceType, k -> new Object2LongOpenHashMap())).addTo((Object)item_id, amount);
    }
}

