/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.capability.BlockEntityCapabilityProvider;
import ca.teamdman.sfm.common.capability.CauldronBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.RedstoneSignalCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.registry.SFMDeferredRegister;
import ca.teamdman.sfm.common.registry.SFMDeferredRegisterBuilder;
import ca.teamdman.sfm.common.registry.SFMRegistryObject;
import ca.teamdman.sfm.common.registry.SFMRegistryWrapper;
import ca.teamdman.sfm.common.util.SFMResourceLocation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;

public class SFMGlobalBlockCapabilityProviders {
    public static final ResourceKey<Registry<SFMBlockCapabilityProvider<?>>> REGISTRY_ID = SFMResourceLocation.createSFMRegistryKey("capability_provider_mappers");
    private static final SFMDeferredRegister<SFMBlockCapabilityProvider<?>> REGISTERER = new SFMDeferredRegisterBuilder().namespace("sfm").registry(REGISTRY_ID).createNewRegistry().build();
    public static final SFMRegistryObject<SFMBlockCapabilityProvider<?>, CauldronBlockCapabilityProvider> CAULDRON_MAPPER = REGISTERER.register("cauldron", CauldronBlockCapabilityProvider::new);
    public static final SFMRegistryObject<SFMBlockCapabilityProvider<?>, BlockEntityCapabilityProvider> BLOCK_ENTITY = REGISTERER.register("block_entity", BlockEntityCapabilityProvider::new);
    public static final SFMRegistryObject<SFMBlockCapabilityProvider<?>, RedstoneSignalCapabilityProvider> REDSTONE = REGISTERER.register("redstone", RedstoneSignalCapabilityProvider::new);

    public static ArrayList<SFMBlockCapabilityProvider<?>> getAllProviders() {
        return REGISTERER.registry().stream().sorted(Comparator.comparingInt(provider -> provider.priority()).reversed()).collect(Collectors.toCollection(ArrayList::new));
    }

    public static SFMRegistryWrapper<SFMBlockCapabilityProvider<?>> registry() {
        return REGISTERER.registry();
    }

    public static void register(IEventBus bus) {
        REGISTERER.register(bus);
    }
}

