/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.client.ClientTranslationHelpers;
import ca.teamdman.sfm.client.text_styling.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.Level;

public class LogsTextStylingHelper {
    public static List<MutableComponent> getStyledLogs(Iterable<TranslatableLogEvent> logs) {
        ArrayList<MutableComponent> processedLogs = new ArrayList<MutableComponent>();
        for (TranslatableLogEvent log : logs) {
            int secondsAgo = Math.toIntExact(log.instant().elapsed().toSeconds());
            int minutes = secondsAgo / 60;
            MutableComponent ago = Component.literal((String)(minutes + "m" + (secondsAgo %= 60) + "s ago")).withStyle(ChatFormatting.GRAY);
            MutableComponent level = Component.literal((String)(" [" + log.level() + "] "));
            if (log.level() == Level.ERROR) {
                level = level.withStyle(ChatFormatting.RED);
            } else if (log.level() == Level.WARN) {
                level = level.withStyle(ChatFormatting.YELLOW);
            } else if (log.level() == Level.INFO) {
                level = level.withStyle(ChatFormatting.GREEN);
            } else if (log.level() == Level.DEBUG) {
                level = level.withStyle(ChatFormatting.AQUA);
            } else if (log.level() == Level.TRACE) {
                level = level.withStyle(ChatFormatting.DARK_GRAY);
            }
            String[] lines = ClientTranslationHelpers.resolveTranslation(log.contents()).split("\n", -1);
            StringBuilder codeBlock = new StringBuilder();
            boolean insideCodeBlock = false;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.equals("```")) {
                    if (insideCodeBlock) {
                        List<MutableComponent> codeLines = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(codeBlock.toString(), false);
                        processedLogs.addAll(codeLines);
                        codeBlock = new StringBuilder();
                        continue;
                    }
                    insideCodeBlock = true;
                    continue;
                }
                if (insideCodeBlock) {
                    codeBlock.append(line).append("\n");
                    continue;
                }
                MutableComponent lineComponent = Component.literal((String)line).withStyle(ChatFormatting.WHITE);
                if (i == 0) {
                    lineComponent = ago.append((Component)level).append((Component)lineComponent);
                }
                processedLogs.add(lineComponent);
            }
        }
        return processedLogs;
    }
}

