/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen.text_editor;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ProgramTokenContextActions;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.screen.SFMTextEditorConfigScreen;
import ca.teamdman.sfm.client.screen.SFMWidgetUtils;
import ca.teamdman.sfm.client.screen.text_editor.ISFMTextEditScreen;
import ca.teamdman.sfm.client.screen.text_editor.SFMTextEditorUtils;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditScreenOpenContext;
import ca.teamdman.sfm.client.text_editor.SFMTextEditorIntellisenseLevel;
import ca.teamdman.sfm.client.text_styling.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.widget.PickList;
import ca.teamdman.sfm.client.widget.PickListItem;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMComponentUtils;
import ca.teamdman.sfm.common.util.SFMDisplayUtils;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.intellisense.IntellisenseAction;
import ca.teamdman.sfml.intellisense.IntellisenseContext;
import ca.teamdman.sfml.intellisense.SFMLIntellisense;
import ca.teamdman.sfml.manipulation.ManipulationResult;
import ca.teamdman.sfml.manipulation.ProgramStringManipulationUtils;
import ca.teamdman.sfml.program_builder.ProgramBuildResult;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SFMTextEditScreenV1
extends Screen
implements ISFMTextEditScreen {
    private final ISFMTextEditScreenOpenContext openContext;
    protected MyMultiLineEditBox textarea;
    protected String lastProgram = "";
    protected List<MutableComponent> content = new ArrayList<MutableComponent>();
    protected PickList<IntellisenseAction> suggestedActions;
    private boolean scrolledOnFirstInit = false;

    public SFMTextEditScreenV1(ISFMTextEditScreenOpenContext openContext) {
        super((Component)LocalizationKeys.TEXT_EDIT_SCREEN_TITLE.getComponent());
        this.openContext = openContext;
    }

    public void scrollToTop() {
        this.textarea.scrollToTop();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void saveAndClose() {
        this.openContext.onSaveAndClose(this.textarea.getValue());
    }

    public void onClose() {
        this.openContext.onTryClose(this.textarea.getValue(), SFMScreenChangeHelpers::popScreen);
    }

    @Override
    public ISFMTextEditScreenOpenContext openContext() {
        return this.openContext;
    }

    @Override
    public void onPreferenceChanged() {
        this.textarea.rebuildIntellisense();
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.hasControlDown());
            return true;
        }
        return false;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (Screen.hasControlDown() && pCodePoint == ' ') {
            return true;
        }
        if (!this.suggestedActions.isEmpty() && pCodePoint == '\\') {
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && Screen.hasShiftDown()) {
            this.saveAndClose();
            return true;
        }
        if (pKeyCode == 258) {
            String content = this.textarea.getValue();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            double scrollAmount = this.textarea.getScrollAmount();
            ManipulationResult result = Screen.hasShiftDown() ? ProgramStringManipulationUtils.deindent(content, cursor, selectionCursor) : ProgramStringManipulationUtils.indent(content, cursor, selectionCursor);
            this.textarea.setValue(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.setScrollAmount(scrollAmount);
            return true;
        }
        if (pKeyCode == 92 && !this.suggestedActions.isEmpty()) {
            IntellisenseAction action = this.suggestedActions.getSelected();
            assert (action != null);
            ManipulationResult result = action.perform(new IntellisenseContext(new ProgramBuilder(this.textarea.getValue()).build(), this.textarea.getCursorPosition(), this.textarea.getSelectionCursorPosition(), this.openContext.labelPositionHolder(), (SFMTextEditorIntellisenseLevel)((Object)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.intellisenseLevel.get())));
            double scrollAmount = this.textarea.getScrollAmount();
            this.textarea.setValue(result.content());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setScrollAmount(scrollAmount);
            return true;
        }
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.hasControlDown());
            return true;
        }
        if (pKeyCode == 47 && Screen.hasControlDown()) {
            String content = this.textarea.getValue();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            ManipulationResult result = ProgramStringManipulationUtils.toggleComments(content, cursor, selectionCursor);
            this.textarea.setValue(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 32 && Screen.hasControlDown()) {
            ProgramTokenContextActions.getContextAction(this.textarea.getValue(), this.textarea.getCursorPosition()).ifPresent(Runnable::run);
            this.textarea.rebuild(false);
            return true;
        }
        if (!(pKeyCode != 265 && pKeyCode != 264 || this.suggestedActions.getItems().isEmpty())) {
            if (pKeyCode == 265) {
                this.suggestedActions.selectPreviousWrapping();
            } else {
                this.suggestedActions.selectNextWrapping();
            }
            return true;
        }
        if (pKeyCode == 256 && !this.suggestedActions.isEmpty()) {
            this.suggestedActions.clear();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void resize(Minecraft mc, int x, int y) {
        String prev = this.textarea.getValue();
        this.init(mc, x, y);
        super.resize(mc, x, y);
        this.textarea.setValue(prev);
    }

    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.renderTransparentBackground(graphics);
        super.render(graphics, mx, my, partialTicks);
        SFMWidgetUtils.hideTooltipsWhenNotFocused(this, this.renderables);
        SFMWidgetUtils.renderChildTooltips(graphics.pose(), mx, my, this.renderables);
    }

    protected void init() {
        super.init();
        SFMScreenRenderUtils.enableKeyRepeating();
        this.textarea = (MyMultiLineEditBox)this.addRenderableWidget((GuiEventListener)new MyMultiLineEditBox(this.font, this.width / 2 - 200, this.height / 2 - 110, 400, 200, (Component)Component.literal((String)""), (Component)Component.literal((String)"")));
        Objects.requireNonNull(this.font);
        this.suggestedActions = (PickList)this.addRenderableWidget((GuiEventListener)new PickList(this.font, 0, 0, 180, 9 * 6, (Component)LocalizationKeys.INTELLISENSE_PICK_LIST_GUI_TITLE.getComponent(), new ArrayList()));
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 200, this.height / 2 - 100 + 195).setSize(16, 20).setText((Component)Component.literal((String)"#")).setOnPress(button -> {
            int cursorPos = this.textarea.getCursorPosition();
            int selectionCursorPos = this.textarea.getSelectionCursorPosition();
            SFMScreenChangeHelpers.setOrPushScreen(new SFMTextEditorConfigScreen(this, SFMConfig.CLIENT_TEXT_EDITOR_CONFIG, () -> {
                this.setInitialFocus((GuiEventListener)this.textarea);
                this.textarea.setCursorPosition(cursorPos);
                this.textarea.setSelectionCursorPosition(selectionCursorPos);
            }));
        }).setTooltip((Screen)this, this.font, LocalizationKeys.PROGRAM_EDIT_SCREEN_CONFIG_BUTTON_TOOLTIP).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 2 - 150, this.height / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.GUI_DONE).setOnPress(button -> this.saveAndClose()).setTooltip((Screen)this, this.font, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 2 + 100, this.height / 2 - 100 + 195).setSize(100, 20).setText(CommonComponents.GUI_CANCEL).setOnPress(button -> this.onClose()).build());
        this.textarea.setValue(this.openContext.initialValue());
        if (!this.scrolledOnFirstInit) {
            this.scrollToTop();
            this.scrolledOnFirstInit = true;
        }
        this.setInitialFocus((GuiEventListener)this.textarea);
    }

    public void tick() {
        this.textarea.tick();
    }

    protected class MyMultiLineEditBox
    extends MultiLineEditBox {
        private final List<Integer> displayedLineStartOffsets;
        @Nullable
        private ProgramBuildResult cachedBuildResult;
        private String cachedBuildProgram;
        private boolean scrollbarDragActive;
        private boolean scrollingEnabled;
        private int cursorBlinkTick;

        public MyMultiLineEditBox(Font pFont, int pX, int pY, int pWidth, int pHeight, Component pPlaceholder, Component pMessage) {
            super(pFont, pX, pY, pWidth, pHeight, pPlaceholder, pMessage);
            this.displayedLineStartOffsets = new ArrayList<Integer>();
            this.cachedBuildProgram = "";
            this.scrollingEnabled = true;
            this.cursorBlinkTick = 0;
            this.textField.setValueListener(this::onValueOrCursorChanged);
            this.textField.setCursorListener(() -> this.onValueOrCursorChanged(this.textField.value()));
            this.rebuild(false);
        }

        public void scrollToTop() {
            this.setScrollAmount(0.0);
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
        }

        public int getCursorPosition() {
            return this.textField.cursor;
        }

        public void setCursorPosition(int cursor) {
            this.textField.seekCursor(Whence.ABSOLUTE, cursor);
        }

        public int getScrollBarHeight() {
            int rtn = super.getScrollBarHeight();
            if (rtn == this.height) {
                return rtn - 1;
            }
            return rtn;
        }

        @MCVersionDependentBehaviour
        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            try {
                boolean rtn;
                boolean clickedScrollbar;
                if (pButton == 0) {
                    this.scrollbarDragActive = false;
                }
                if (pButton == 0 && this.visible && this.withinContentAreaPoint(pMouseX, pMouseY)) {
                    if (SFMTextEditScreenV1.this.content.isEmpty()) {
                        return false;
                    }
                    this.setFocused(true);
                    boolean shiftDown = Screen.hasShiftDown();
                    this.seekCursorFromPoint(pMouseX, pMouseY);
                    if (!shiftDown) {
                        this.textField.selectCursor = this.textField.cursor;
                    }
                    this.textField.setSelecting(true);
                    return true;
                }
                boolean bl = clickedScrollbar = pButton == 0 && this.visible && this.scrollbarVisible() && pMouseX >= (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.width) && pMouseX <= (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.width + 8) && pMouseY >= (double)SFMWidgetUtils.getY((AbstractWidget)this) && pMouseY < (double)(SFMWidgetUtils.getY((AbstractWidget)this) + this.height);
                if (clickedScrollbar) {
                    this.scrollbarDragActive = true;
                }
                if (!this.visible) {
                    rtn = false;
                } else {
                    boolean flag1;
                    boolean flag = this.withinContentAreaPoint(pMouseX, pMouseY);
                    boolean bl2 = flag1 = this.scrollbarVisible() && pMouseX >= (double)(this.getX() + this.width) && pMouseX <= (double)(this.getX() + this.width + 8) && pMouseY >= (double)this.getY() && pMouseY < (double)(this.getY() + this.height);
                    if (flag1 && pButton == 0) {
                        this.scrolling = true;
                        rtn = true;
                    } else {
                        rtn = false;
                    }
                }
                if (rtn) {
                    return true;
                }
                if (this.withinContentAreaPoint(pMouseX, pMouseY) && pButton == 0) {
                    this.textField.setSelecting(Screen.hasShiftDown());
                    this.seekCursorScreen(pMouseX, pMouseY);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in SFMTextEditScreenV1.MyMultiLineEditBox.mouseClicked", (Throwable)e);
                return false;
            }
        }

        public int getInnerHeight() {
            Objects.requireNonNull(this.font);
            return 9 * (SFMTextEditScreenV1.this.content.size() + 2);
        }

        public boolean mouseDragged(double mx, double my, int button, double dx, double dy) {
            if (this.scrollbarDragActive && super.mouseDragged(mx, my, button, dx, dy)) {
                return true;
            }
            try {
                if (button == 0 && this.visible && this.withinContentAreaPoint(mx, my)) {
                    if (SFMTextEditScreenV1.this.content.isEmpty()) {
                        return false;
                    }
                    this.textField.setSelecting(true);
                    this.seekCursorFromPoint(mx, my);
                    return true;
                }
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in SFMTextEditScreenV1.MyMultiLineEditBox.mouseDragged", (Throwable)e);
                return false;
            }
            return false;
        }

        public boolean mouseReleased(double mx, double my, int button) {
            if (button == 0) {
                this.textField.setSelecting(false);
                this.scrollbarDragActive = false;
            }
            return super.mouseReleased(mx, my, button);
        }

        public int getSelectionCursorPosition() {
            return this.textField.selectCursor;
        }

        public void setSelectionCursorPosition(int cursor) {
            this.textField.selectCursor = cursor;
        }

        public double getScrollAmount() {
            return this.scrollAmount();
        }

        protected void setScrollAmount(double pScrollAmount) {
            if (!this.scrollingEnabled) {
                return;
            }
            super.setScrollAmount(pScrollAmount);
        }

        private void seekCursorFromPoint(double mx, double my) {
            int lineCount = SFMTextEditScreenV1.this.content.size();
            double innerX = mx - (double)(SFMWidgetUtils.getX((AbstractWidget)this) + this.innerPadding() + SFMTextEditorUtils.getLineNumberWidth(this.font, lineCount));
            double innerY = my - (double)(SFMWidgetUtils.getY((AbstractWidget)this) + this.innerPadding()) + this.scrollAmount();
            Objects.requireNonNull(this.font);
            int lineIndex = Mth.clamp((int)((int)Math.floor(innerY / (double)Math.max(1, 9))), (int)0, (int)Math.max(0, lineCount - 1));
            int cursorPosition = this.pointToCursor(innerX, lineIndex);
            this.scrollingEnabled = false;
            this.textField.seekCursor(Whence.ABSOLUTE, cursorPosition);
            this.scrollingEnabled = true;
        }

        private int getLineStartIndex(int lineIndex) {
            if (this.displayedLineStartOffsets.isEmpty()) {
                return 0;
            }
            int clamped = Mth.clamp((int)lineIndex, (int)0, (int)Math.max(0, this.displayedLineStartOffsets.size() - 1));
            return this.displayedLineStartOffsets.get(clamped);
        }

        private int pointToCursor(double innerX, int lineIndex) {
            int nextGlyphWidth;
            int lineStartIndex = this.getLineStartIndex(lineIndex);
            if (SFMTextEditScreenV1.this.content.isEmpty()) {
                return lineStartIndex;
            }
            int clampedLine = Mth.clamp((int)lineIndex, (int)0, (int)Math.max(0, SFMTextEditScreenV1.this.content.size() - 1));
            String plainLine = SFMTextEditScreenV1.this.content.get(clampedLine).getString();
            int clampedX = (int)Math.max(0.0, innerX);
            int cursorOffsetInLine = this.font.plainSubstrByWidth(plainLine, clampedX).length();
            int widthBeforeCursor = this.font.width(plainLine.substring(0, cursorOffsetInLine));
            if (cursorOffsetInLine < plainLine.length() && (double)(clampedX - widthBeforeCursor) >= (double)(nextGlyphWidth = this.font.width(plainLine.substring(cursorOffsetInLine, cursorOffsetInLine + 1))) / 2.0) {
                cursorOffsetInLine = Math.min(plainLine.length(), cursorOffsetInLine + 1);
            }
            return Mth.clamp((int)(lineStartIndex + cursorOffsetInLine), (int)0, (int)this.textField.value().length());
        }

        protected int getMaxScrollAmount() {
            return Math.max(1, super.getMaxScrollAmount());
        }

        private void onValueOrCursorChanged(String programString) {
            ProgramBuildResult buildResult;
            int cursorPosition = this.getCursorPosition();
            if (programString.equals(this.cachedBuildProgram) && this.cachedBuildResult != null) {
                buildResult = this.cachedBuildResult;
            } else {
                buildResult = new ProgramBuilder(programString).build();
                this.cachedBuildProgram = programString;
                this.cachedBuildResult = buildResult;
            }
            IntellisenseContext intellisenseContext = new IntellisenseContext(buildResult, cursorPosition, this.getSelectionCursorPosition(), SFMTextEditScreenV1.this.openContext.labelPositionHolder(), (SFMTextEditorIntellisenseLevel)((Object)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.intellisenseLevel.get()));
            List<IntellisenseAction> suggestions = SFMLIntellisense.getSuggestions(intellisenseContext);
            SFMTextEditScreenV1.this.suggestedActions.setItems(suggestions);
            String cursorWord = buildResult.getWordAtCursorPosition(cursorPosition);
            SFMTextEditScreenV1.this.suggestedActions.setQuery((Component)Component.literal((String)cursorWord));
            boolean shouldPrint = false;
            if (shouldPrint) {
                String cursorPositionDisplay = SFMDisplayUtils.getCursorPositionDisplay(programString, cursorPosition);
                String cursorTokenDisplay = SFMDisplayUtils.getCursorTokenDisplay(buildResult, cursorPosition);
                @Nullable Program program = buildResult.program();
                String tokenHierarchyDisplay = program == null ? "<INVALID PROGRAM>" : SFMDisplayUtils.getTokenHierarchyDisplay(program, cursorPosition);
                String suggestionsDisplay = SFMTextEditScreenV1.this.suggestedActions.getItems().stream().map(PickListItem::getComponent).map(Component::getString).collect(Collectors.joining(", "));
                SFM.LOGGER.info("PROGRAM OR CURSOR CHANGE! {}   {}   {}  |||  {} ||| {}", (Object)cursorPositionDisplay, (Object)cursorTokenDisplay, (Object)tokenHierarchyDisplay, (Object)cursorWord, (Object)suggestionsDisplay);
            }
        }

        private void rebuildIntellisense() {
            this.onValueOrCursorChanged(this.getValue());
        }

        private void rebuild(boolean showContextActionHints) {
            SFMTextEditScreenV1.this.lastProgram = this.textField.value();
            SFMTextEditScreenV1.this.content = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(SFMTextEditScreenV1.this.lastProgram, showContextActionHints);
            this.rebuildDisplayCache();
        }

        private void rebuildDisplayCache() {
            this.displayedLineStartOffsets.clear();
            this.displayedLineStartOffsets.add(0);
            for (int i = 0; i < SFMTextEditScreenV1.this.lastProgram.length(); ++i) {
                if (SFMTextEditScreenV1.this.lastProgram.charAt(i) != '\n') continue;
                this.displayedLineStartOffsets.add(i + 1);
            }
            int lines = SFMTextEditScreenV1.this.content.size();
            while (this.displayedLineStartOffsets.size() > lines) {
                this.displayedLineStartOffsets.remove(this.displayedLineStartOffsets.size() - 1);
            }
            while (this.displayedLineStartOffsets.size() < lines) {
                this.displayedLineStartOffsets.add(SFMTextEditScreenV1.this.lastProgram.length());
            }
        }

        public void tick() {
            ++this.cursorBlinkTick;
        }

        protected void renderContents(GuiGraphics graphics, int mx, int my, float partialTicks) {
            List<MutableComponent> lines;
            Matrix4f matrix4f = graphics.pose().last().pose();
            if (!SFMTextEditScreenV1.this.lastProgram.equals(this.textField.value())) {
                this.rebuild(Screen.hasControlDown());
            }
            if ((lines = SFMTextEditScreenV1.this.content).isEmpty()) {
                return;
            }
            boolean isCursorVisible = this.isFocused() && this.cursorBlinkTick % 20 >= 10;
            int cursorIndex = this.textField.cursor();
            Objects.requireNonNull(this.font);
            int lineHeight = Math.max(1, 9);
            int availableHeight = this.height - this.innerPadding() * 2;
            double scroll = this.scrollAmount();
            int viewLineIndexStart = Mth.clamp((int)((int)Math.floor(scroll / (double)lineHeight)), (int)0, (int)Math.max(0, lines.size() - 1));
            int numVisibleLines = Math.max(1, availableHeight / lineHeight + 2);
            int viewLineIndexEnd = Math.min(lines.size(), viewLineIndexStart + numVisibleLines);
            int lineX = SFMWidgetUtils.getX((AbstractWidget)this) + this.innerPadding() + SFMTextEditorUtils.getLineNumberWidth(this.font, SFMTextEditScreenV1.this.content.size());
            boolean isCursorAtEndOfLine = false;
            boolean drewCursorGlyph = false;
            int contentTopY = SFMWidgetUtils.getY((AbstractWidget)this) + this.innerPadding();
            int lineY = contentTopY + viewLineIndexStart * lineHeight;
            int charCountAccum = this.getLineStartIndex(viewLineIndexStart);
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.textField.getSelected();
            int selectionStart = selectedRange.beginIndex();
            int selectionEnd = selectedRange.endIndex();
            MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
            ArrayList<int[]> highlightRects = new ArrayList<int[]>();
            for (int line = viewLineIndexStart; line < viewLineIndexEnd; ++line) {
                boolean cursorOnThisLine;
                MutableComponent componentColoured = lines.get(line);
                String plainLine = componentColoured.getString();
                int lineLength = plainLine.length();
                boolean bl = cursorOnThisLine = isCursorVisible && cursorIndex >= charCountAccum && cursorIndex <= charCountAccum + lineLength;
                if (SFMTextEditorUtils.shouldShowLineNumbers()) {
                    String lineNumber = String.valueOf(line + 1);
                    SFMFontUtils.drawInBatch(lineNumber, this.font, (float)(lineX - 2 - this.font.width(lineNumber)), (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCountAccum + lineLength;
                    cursorY = lineY;
                    int relativeCursorIndex = cursorIndex - charCountAccum;
                    int drawnWidthBeforeCursor = this.font.width(plainLine.substring(0, relativeCursorIndex));
                    cursorX = lineX + drawnWidthBeforeCursor;
                    SFMFontUtils.drawInBatch((Component)SFMComponentUtils.substring((Component)componentColoured, 0, relativeCursorIndex), this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                    SFMTextEditScreenV1.this.suggestedActions.setXY(cursorX + 10, cursorY);
                    SFMFontUtils.drawInBatch((Component)SFMComponentUtils.substring((Component)componentColoured, relativeCursorIndex, lineLength), this.font, (float)cursorX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                    drewCursorGlyph = true;
                } else {
                    SFMFontUtils.drawInBatch((Component)componentColoured, this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                if (selectionStart <= charCountAccum + lineLength && selectionEnd > charCountAccum) {
                    int lineSelectionStart = Math.max(selectionStart - charCountAccum, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCountAccum, lineLength);
                    int highlightStartX = this.font.width(plainLine.substring(0, lineSelectionStart));
                    int highlightEndX = this.font.width(plainLine.substring(0, lineSelectionEnd));
                    highlightRects.add(new int[]{lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight});
                }
                lineY += lineHeight;
                charCountAccum += lineLength + 1;
            }
            buffer.endBatch();
            for (int[] r : highlightRects) {
                SFMScreenRenderUtils.renderHighlight(graphics, r[0], r[1], r[2], r[3]);
            }
            if (drewCursorGlyph) {
                if (isCursorAtEndOfLine) {
                    SFMFontUtils.draw(graphics, this.font, "_", cursorX, cursorY, -1, true);
                } else {
                    graphics.fill(cursorX, cursorY - 1, cursorX + 1, cursorY + 1 + 9, -1);
                }
            }
        }
    }
}

