/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.capability;

import ca.teamdman.sfm.common.capability.IRedstoneSignalStorage;
import net.minecraft.nbt.IntTag;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class RedstoneSignalStorage
implements IRedstoneSignalStorage,
INBTSerializable<IntTag> {
    public int value = 0;
    private final int maxValue;

    public RedstoneSignalStorage(int signal, int maxValue) {
        this.maxValue = Mth.clamp((int)maxValue, (int)0, (int)Integer.MAX_VALUE);
        this.value = Mth.clamp((int)signal, (int)0, (int)this.maxValue);
    }

    @Override
    public int insert(int amount, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int accept = Mth.clamp((int)amount, (int)0, (int)(this.maxValue - this.value));
        if (!simulate) {
            this.value += accept;
        }
        return accept;
    }

    @Override
    public int extract(int amount, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int extract = Mth.clamp((int)amount, (int)0, (int)this.value);
        if (!simulate) {
            this.value -= extract;
        }
        return extract;
    }

    @Override
    public int getStoredAmount() {
        return this.value;
    }

    @Override
    public int getMaxStoredAmount() {
        return this.maxValue;
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    public void deserializeNBT(IntTag nbt) {
        this.value = nbt.getAsInt();
    }

    public IntTag serializeNBT() {
        return IntTag.valueOf((int)this.value);
    }
}

