/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.config.SFMConfig;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SFMServerConfig {
    public final ModConfigSpec.BooleanValue disableProgramExecution;
    public final ModConfigSpec.BooleanValue logResourceLossToConsole;
    public final ModConfigSpec.IntValue timerTriggerMinimumIntervalInTicks;
    public final ModConfigSpec.IntValue timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO;
    public final ModConfigSpec.IntValue maxIfStatementsInTriggerBeforeSimulationIsntAllowed;
    public final ModConfigSpec.IntValue maxDiskProblems;
    public final ModConfigSpec.ConfigValue<List<? extends String>> disallowedResourceTypesForTransfer;
    public final ModConfigSpec.EnumValue<LevelsToShards> levelsToShards;
    private int revision = 0;

    SFMServerConfig(ModConfigSpec.Builder builder) {
        builder.comment("This config is shown to clients, don't put anything secret in here");
        this.disableProgramExecution = builder.comment("Prevents factory managers from compiling and running code (for emergencies)").define("disableProgramExecution", false);
        this.logResourceLossToConsole = builder.comment("Log resource loss to console").define("logResourceLossToConsole", true);
        this.timerTriggerMinimumIntervalInTicks = builder.defineInRange("timerTriggerMinimumIntervalInTicks", 20, 1, Integer.MAX_VALUE);
        this.timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIO = builder.defineInRange("timerTriggerMinimumIntervalInTicksWhenOnlyForgeEnergyIOStatementsPresent", 1, 1, Integer.MAX_VALUE);
        this.maxIfStatementsInTriggerBeforeSimulationIsntAllowed = builder.comment("The number of scenarios to check is 2^n where n is the number of if statements in a trigger").defineInRange("maxIfStatementsInTriggerBeforeSimulationIsntAllowed", 10, 0, Integer.MAX_VALUE);
        this.maxDiskProblems = builder.comment("The max number of problems annotated on a disk item before truncation").defineInRange("maxDiskProblems", 10, 0, Integer.MAX_VALUE);
        this.disallowedResourceTypesForTransfer = builder.comment("What resource types should SFM not be allowed to move").defineListAllowEmpty(List.of("disallowedResourceTypesForTransfer"), List::of, String.class::isInstance);
        this.levelsToShards = builder.comment(new String[]{"How to convert Enchanted Books to Experience Shards", "JustOne = always produces 1 shard regardless of enchantments", "EachOne = produces 1 shard per enchantment on the book.", "SumLevels = produces a number of shards equal to the sum of the enchantments' levels", "SumLevelsScaledExponentially = produces a number of shards equal to the sum of 2 to the power of each enchantment's level (1 -> 1 shard, 2 -> 4 shards, 3 -> 8 shards, etc)"}).defineEnum("levelsToShards", (Enum)LevelsToShards.JustOne);
    }

    public int getRevision() {
        return this.revision;
    }

    @SubscribeEvent
    public static void onConfigLoaded(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SFMConfig.SERVER_CONFIG_SPEC) {
            ++SFMConfig.SERVER_CONFIG.revision;
            SFM.LOGGER.info("SFM config loaded, now on revision {}", (Object)SFMConfig.SERVER_CONFIG.revision);
        }
    }

    @SubscribeEvent
    public static void onConfigReloaded(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SFMConfig.SERVER_CONFIG_SPEC) {
            ++SFMConfig.SERVER_CONFIG.revision;
            SFM.LOGGER.info("SFM config reloaded, now on revision {}", (Object)SFMConfig.SERVER_CONFIG.revision);
        }
    }

    public static enum LevelsToShards {
        JustOne,
        EachOne,
        SumLevels,
        SumLevelsScaledExponentially;

    }
}

