/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.enchantment;

import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollectionKind;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentEntry;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentKey;
import ca.teamdman.sfm.common.registry.SFMWellKnownRegistries;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SFMEnchantmentCollection
implements Collection<SFMEnchantmentEntry> {
    private final List<SFMEnchantmentEntry> inner = new ArrayList<SFMEnchantmentEntry>();

    @Override
    public boolean addAll(@NotNull Collection<? extends SFMEnchantmentEntry> c) {
        return this.inner.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    public static SFMEnchantmentCollection empty() {
        return new SFMEnchantmentCollection();
    }

    @MCVersionDependentBehaviour
    public static SFMEnchantmentCollection fromItemStack(ItemStack stack, SFMEnchantmentCollectionKind kind) {
        SFMEnchantmentCollection rtn = new SFMEnchantmentCollection();
        switch (kind) {
            case HoldingLikeABook: {
                ListTag enchantedBookEnchantments = EnchantedBookItem.getEnchantments((ItemStack)stack);
                int numEnchantments = enchantedBookEnchantments.size();
                for (int i = 0; i < numEnchantments; ++i) {
                    Enchantment enchantment;
                    CompoundTag compoundTag = enchantedBookEnchantments.getCompound(i);
                    ResourceLocation id = EnchantmentHelper.getEnchantmentId((CompoundTag)compoundTag);
                    if (id == null || (enchantment = SFMWellKnownRegistries.ENCHANTMENTS.get(id)) == null) continue;
                    SFMEnchantmentKey key = new SFMEnchantmentKey(enchantment);
                    int level = EnchantmentHelper.getEnchantmentLevel((CompoundTag)compoundTag);
                    SFMEnchantmentEntry entry = new SFMEnchantmentEntry(key, level);
                    rtn.add(entry);
                }
                break;
            }
            case EnchantedLikeATool: {
                Map enchantments = EnchantmentHelper.getEnchantments((ItemStack)stack);
                for (Map.Entry enchantmentEntry : enchantments.entrySet()) {
                    Enchantment enchantment = (Enchantment)enchantmentEntry.getKey();
                    SFMEnchantmentKey key = new SFMEnchantmentKey(enchantment);
                    Integer level = (Integer)enchantmentEntry.getValue();
                    SFMEnchantmentEntry entry = new SFMEnchantmentEntry(key, level);
                    rtn.add(entry);
                }
                break;
            }
        }
        return rtn;
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(o);
    }

    @Override
    public boolean add(SFMEnchantmentEntry entry) {
        return this.inner.add(entry);
    }

    @Override
    public boolean remove(Object o) {
        return this.inner.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.inner.containsAll(c);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public Iterator<SFMEnchantmentEntry> iterator() {
        return this.inner.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.inner.toArray(a);
    }

    public Map<SFMEnchantmentKey, SFMEnchantmentEntry> canonicalize() {
        HashMap<SFMEnchantmentKey, SFMEnchantmentEntry> rtn = new HashMap<SFMEnchantmentKey, SFMEnchantmentEntry>();
        for (SFMEnchantmentEntry enchantment : this) {
            rtn.put(enchantment.key(), enchantment);
        }
        return rtn;
    }

    public void write(ItemStack stack, SFMEnchantmentCollectionKind kind) {
        switch (kind) {
            case HoldingLikeABook: {
                stack.getOrCreateTag().remove("StoredEnchantments");
                for (SFMEnchantmentEntry enchantment : this.canonicalize().values()) {
                    EnchantedBookItem.addEnchantment((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(enchantment.key().inner(), enchantment.level()));
                }
                break;
            }
            case EnchantedLikeATool: {
                HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
                for (SFMEnchantmentEntry enchantment : this.canonicalize().values()) {
                    enchantments.put(enchantment.key().inner(), enchantment.level());
                }
                EnchantmentHelper.setEnchantments(enchantments, (ItemStack)stack);
            }
        }
    }

    public int getLevel(SFMEnchantmentKey enchant) {
        for (SFMEnchantmentEntry entry : this) {
            if (!entry.key().equals(enchant)) continue;
            return entry.level();
        }
        return 0;
    }

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof SFMEnchantmentCollection)) {
            return false;
        }
        SFMEnchantmentCollection that = (SFMEnchantmentCollection)o;
        return this.inner.equals(that.inner);
    }

    @Override
    public int hashCode() {
        return this.inner.hashCode();
    }

    public ItemStack createEnchantedBook() {
        ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        this.write(book, SFMEnchantmentCollectionKind.HoldingLikeABook);
        return book;
    }
}

