/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.handler;

import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.config.SFMServerConfig;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollection;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollectionKind;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentEntry;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMBlockTags;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FallingAnvilHandler {
    @SubscribeEvent
    public static void onLeave(EntityLeaveLevelEvent event) {
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof FallingBlockEntity)) {
            return;
        }
        FallingBlockEntity fbe = (FallingBlockEntity)entity;
        if (!(fbe.getBlockState().getBlock() instanceof AnvilBlock)) {
            return;
        }
        BlockPos anvilPos = fbe.blockPosition();
        if (!level.isLoaded(anvilPos)) {
            return;
        }
        Block blockLandedUpon = level.getBlockState(anvilPos.below()).getBlock();
        boolean tryFormCreation = SFMBlockTags.blockHasTag(blockLandedUpon, SFMBlockTags.ANVIL_PRINTING_PRESS_FORMING);
        boolean tryCrushing = SFMBlockTags.blockHasTag(blockLandedUpon, SFMBlockTags.ANVIL_DISENCHANTING);
        if (!tryCrushing && !tryFormCreation) {
            return;
        }
        List itemEntities = level.getEntitiesOfClass(ItemEntity.class, new AABB(anvilPos));
        itemEntities.removeIf(itemEntity -> !itemEntity.isAlive() || itemEntity.getItem().isEmpty());
        if (tryFormCreation) {
            FallingAnvilHandler.handlePrintingPressFormCreation(level, anvilPos, itemEntities);
        } else if (tryCrushing) {
            FallingAnvilHandler.crushEnchantedBooksIntoXpShards(level, anvilPos, itemEntities);
            itemEntities.removeIf(itemEntity -> !itemEntity.isAlive() || itemEntity.getItem().isEmpty());
            FallingAnvilHandler.removeEnchantmentsFromItems(level, anvilPos, itemEntities);
        }
    }

    public static int getShardCountForEnchantments(SFMServerConfig.LevelsToShards config, SFMEnchantmentCollection enchantments) {
        return switch (config) {
            default -> throw new IncompatibleClassChangeError();
            case SFMServerConfig.LevelsToShards.JustOne -> 1;
            case SFMServerConfig.LevelsToShards.EachOne -> enchantments.size();
            case SFMServerConfig.LevelsToShards.SumLevels -> {
                int sum = 0;
                for (SFMEnchantmentEntry enchantment : enchantments) {
                    sum += enchantment.level();
                }
                yield sum;
            }
            case SFMServerConfig.LevelsToShards.SumLevelsScaledExponentially -> {
                int sum = 0;
                for (SFMEnchantmentEntry enchantment : enchantments) {
                    int incr = 1 << Math.max(0, enchantment.level() - 1);
                    if (sum + incr > 0) {
                        sum += incr;
                        continue;
                    }
                    sum = Integer.MAX_VALUE;
                }
                yield sum;
            }
        };
    }

    private static void removeEnchantmentsFromItems(Level level, BlockPos anvilPos, List<ItemEntity> items) {
        ArrayList<ItemEntity> bookItemEntities = new ArrayList<ItemEntity>();
        ArrayList<ItemEntity> nonBookItemEntities = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : items) {
            if (itemEntity.getItem().is(Items.BOOK)) {
                bookItemEntities.add(itemEntity);
                continue;
            }
            nonBookItemEntities.add(itemEntity);
        }
        int booksAvailable = 0;
        for (ItemEntity itemEntity : bookItemEntities) {
            int count = itemEntity.getItem().getCount();
            booksAvailable += count;
        }
        for (ItemEntity itemEntity : nonBookItemEntities) {
            ItemStack stack = itemEntity.getItem();
            SFMEnchantmentCollection enchantments = SFMEnchantmentCollection.fromItemStack(stack, SFMEnchantmentCollectionKind.EnchantedLikeATool);
            if (enchantments.isEmpty()) continue;
            int stackSize = stack.getCount();
            Iterator<SFMEnchantmentEntry> iter = enchantments.iterator();
            while (iter.hasNext() && booksAvailable >= stackSize) {
                SFMEnchantmentEntry enchantment = iter.next();
                ItemStack enchantedBookToSpawn = enchantment.createEnchantedBook();
                enchantedBookToSpawn.setCount(stackSize);
                level.addFreshEntity((Entity)new ItemEntity(level, (double)anvilPos.getX(), (double)anvilPos.getY(), (double)anvilPos.getZ(), enchantedBookToSpawn));
                iter.remove();
                enchantments.write(stack, SFMEnchantmentCollectionKind.EnchantedLikeATool);
                booksAvailable -= stackSize;
            }
        }
        for (ItemEntity itemEntity : bookItemEntities) {
            itemEntity.discard();
        }
        while (booksAvailable > 0) {
            int n = Math.min(booksAvailable, 64);
            level.addFreshEntity((Entity)new ItemEntity(level, (double)anvilPos.getX(), (double)anvilPos.getY(), (double)anvilPos.getZ(), new ItemStack((ItemLike)Items.BOOK, n)));
            booksAvailable -= n;
        }
    }

    private static void crushEnchantedBooksIntoXpShards(Level level, BlockPos anvilPos, List<ItemEntity> items) {
        for (ItemEntity itemEntity : items) {
            int shardStackSize;
            ItemStack stack = itemEntity.getItem();
            if (!stack.is(Items.ENCHANTED_BOOK)) continue;
            SFMEnchantmentCollection enchantments = SFMEnchantmentCollection.fromItemStack(stack, SFMEnchantmentCollectionKind.HoldingLikeABook);
            long shardsForEnchantments = FallingAnvilHandler.getShardCountForEnchantments((SFMServerConfig.LevelsToShards)((Object)SFMConfig.SERVER_CONFIG.levelsToShards.get()), enchantments);
            itemEntity.discard();
            for (long shardsToSpawn = (long)stack.getCount() * shardsForEnchantments; shardsToSpawn > 0L; shardsToSpawn -= (long)shardStackSize) {
                shardStackSize = (int)Math.min(64L, shardsToSpawn);
                ItemStack shardStack = new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get(), shardStackSize);
                ItemEntity shardItemEntity = new ItemEntity(level, (double)anvilPos.getX(), (double)anvilPos.getY(), (double)anvilPos.getZ(), shardStack);
                level.addFreshEntity((Entity)shardItemEntity);
            }
        }
    }

    private static void handlePrintingPressFormCreation(Level level, BlockPos anvilPos, List<ItemEntity> itemEntities) {
        List recipes = level.getRecipeManager().getAllRecipesFor(SFMRecipeTypes.PRINTING_PRESS.get());
        boolean consumeBlock = false;
        block0: for (ItemEntity itemEntity : itemEntities) {
            for (RecipeHolder recipeHolder : recipes) {
                PrintingPressRecipe recipe = (PrintingPressRecipe)recipeHolder.value();
                if (!recipe.form().test(itemEntity.getItem())) continue;
                ItemStack formStack = FormItem.createFormFromReference(itemEntity.getItem());
                level.addFreshEntity((Entity)new ItemEntity(level, (double)anvilPos.getX(), (double)anvilPos.getY(), (double)anvilPos.getZ(), formStack));
                itemEntity.discard();
                consumeBlock = true;
                continue block0;
            }
        }
        if (consumeBlock) {
            level.setBlockAndUpdate(anvilPos.below(), Blocks.AIR.defaultBlockState());
        }
    }
}

