/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.recipe;

import ca.teamdman.sfm.common.blockentity.PrintingPressBlockEntity;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.registry.SFMRecipeSerializers;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record PrintingPressRecipe(Ingredient form, Ingredient ink, Ingredient paper) implements Recipe<PrintingPressBlockEntity>
{
    public boolean matches(PrintingPressBlockEntity pContainer, Level pLevel) {
        return this.paper.test(pContainer.getPaper()) && this.ink.test(pContainer.getInk()) && this.form.test(FormItem.getBorrowedReferenceFromForm(pContainer.getForm()));
    }

    @MCVersionDependentBehaviour
    public ItemStack assemble(PrintingPressBlockEntity pContainer, RegistryAccess p_267165_) {
        ItemStack rtn = FormItem.getCopiedReferenceFromForm(pContainer.getForm());
        rtn.setCount(pContainer.getPaper().getCount());
        return rtn;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @MCVersionDependentBehaviour
    public ItemStack getResultItem(RegistryAccess p_267052_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return SFMRecipeSerializers.PRINTING_PRESS.get();
    }

    public RecipeType<?> getType() {
        return SFMRecipeTypes.PRINTING_PRESS.get();
    }

    @Override
    @MCVersionDependentBehaviour
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PrintingPressRecipe that = (PrintingPressRecipe)obj;
        return Objects.equals(this.form, that.form) && Objects.equals(this.ink, that.ink) && Objects.equals(this.paper, that.paper);
    }

    @Override
    @MCVersionDependentBehaviour
    public int hashCode() {
        return Objects.hash(this.form, this.ink, this.paper);
    }

    @Override
    public String toString() {
        return "PrintingPressRecipe[form=" + this.form + ", ink=" + this.ink + ", paper=" + this.paper + "]";
    }

    @MCVersionDependentBehaviour
    public static class Serializer
    implements RecipeSerializer<PrintingPressRecipe> {
        private final Codec<PrintingPressRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("form").forGetter(PrintingPressRecipe::form), (App)Ingredient.CODEC.fieldOf("ink").forGetter(PrintingPressRecipe::ink), (App)Ingredient.CODEC.fieldOf("paper").forGetter(PrintingPressRecipe::paper)).apply((Applicative)instance, PrintingPressRecipe::new));

        public Codec<PrintingPressRecipe> codec() {
            return this.CODEC;
        }

        public PrintingPressRecipe fromNetwork(FriendlyByteBuf friendlyByteBuf) {
            Ingredient form = Ingredient.fromNetwork((FriendlyByteBuf)friendlyByteBuf);
            Ingredient ink = Ingredient.fromNetwork((FriendlyByteBuf)friendlyByteBuf);
            Ingredient paper = Ingredient.fromNetwork((FriendlyByteBuf)friendlyByteBuf);
            return new PrintingPressRecipe(form, ink, paper);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PrintingPressRecipe pRecipe) {
            pRecipe.form.toNetwork(pBuffer);
            pRecipe.ink.toNetwork(pBuffer);
            pRecipe.paper.toNetwork(pBuffer);
        }
    }
}

