/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.registry.SFMRegistryObject;
import ca.teamdman.sfm.common.registry.SFMRegistryWrapper;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

@MCVersionDependentBehaviour
public class SFMDeferredRegister<T> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    @MCVersionDependentBehaviour
    @Nullable
    private final DeferredRegister<T> inner;
    private final String namespace;
    private final SFMRegistryWrapper<T> registryWrapper;

    public SFMDeferredRegister(ResourceKey<? extends Registry<T>> registryKey, String namespace, @Nullable DeferredRegister<T> inner) {
        this.registryKey = registryKey;
        this.registryWrapper = new SFMRegistryWrapper(registryKey);
        this.namespace = namespace;
        this.inner = inner;
    }

    public void register(IEventBus bus) {
        if (this.inner == null) {
            return;
        }
        this.inner.register(bus);
    }

    public int size() {
        if (this.inner == null) {
            throw new IllegalStateException("Tried to get size of conditionally disabled SFMDeferredRegister " + this);
        }
        return this.inner.getEntries().size();
    }

    public String namespace() {
        return this.namespace;
    }

    public <I extends T> SFMRegistryObject<T, I> register(String name, Supplier<? extends I> supplier) {
        if (this.inner == null) {
            return this.registerEmpty(name);
        }
        DeferredHolder object = this.inner.register(name, supplier);
        return new SFMRegistryObject(this.registryKey, object);
    }

    public <I extends T> SFMRegistryObject<T, I> registerEmpty(final String name) {
        return new SFMRegistryObject<T, I>(this.registryKey, null){

            @Override
            public I get() {
                throw new IllegalStateException("Tried to get a registry object that was conditionally not registered - " + SFMDeferredRegister.this.registryKey + " " + SFMDeferredRegister.this.namespace() + ":" + name);
            }
        };
    }

    public SFMRegistryWrapper<T> registry() {
        return this.registryWrapper;
    }

    public ArrayList<SFMRegistryObject<T, ? extends T>> getOurEntries() {
        if (this.inner == null) {
            SFM.LOGGER.warn("Attempted to get entries from a registry that was not created via DeferredRegisterBuilder! namespace={}", (Object)this.namespace());
            return new ArrayList<SFMRegistryObject<T, ? extends T>>();
        }
        Collection entries = this.inner.getEntries();
        ArrayList<SFMRegistryObject<T, T>> rtn = new ArrayList<SFMRegistryObject<T, T>>(entries.size());
        for (DeferredHolder entry : entries) {
            if (!entry.isBound()) continue;
            rtn.add(new SFMRegistryObject(this.registryKey, entry));
        }
        return rtn;
    }

    public String toString() {
        return "SFMDeferredRegister{registryKey=" + this.registryKey + ", inner=" + this.inner + ", namespace='" + this.namespace + "', registryWrapper=" + this.registryWrapper + "}";
    }
}

