/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.client.ClientRayCastHelpers;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.blockentity.TestBarrelTankBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.containermenu.TestBarrelTankContainerMenu;
import ca.teamdman.sfm.common.registry.SFMDeferredRegister;
import ca.teamdman.sfm.common.registry.SFMDeferredRegisterBuilder;
import ca.teamdman.sfm.common.registry.SFMRegistryObject;
import ca.teamdman.sfm.common.registry.SFMWellKnownRegistries;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.IContainerFactory;

public class SFMMenus {
    private static final SFMDeferredRegister<MenuType<?>> MENU_TYPES = new SFMDeferredRegisterBuilder().namespace("sfm").registry(SFMWellKnownRegistries.MENU_TYPES.registryKey()).build();
    public static final SFMRegistryObject<MenuType<?>, MenuType<ManagerContainerMenu>> MANAGER_MENU = MENU_TYPES.register("manager", () -> IMenuTypeExtension.create((IContainerFactory)new IContainerFactory<ManagerContainerMenu>(){

        public ManagerContainerMenu create(int windowId, Inventory inv, FriendlyByteBuf data) {
            return new ManagerContainerMenu(windowId, inv, data);
        }

        public ManagerContainerMenu create(int windowId, Inventory inv) {
            if (SFMEnvironmentUtils.isClient()) {
                BlockEntity be = ClientRayCastHelpers.getLookBlockEntity();
                if (!(be instanceof ManagerBlockEntity)) {
                    return (ManagerContainerMenu)super.create(windowId, inv);
                }
                ManagerBlockEntity mbe = (ManagerBlockEntity)be;
                return new ManagerContainerMenu(windowId, inv, mbe);
            }
            return (ManagerContainerMenu)super.create(windowId, inv);
        }
    }));
    public static final SFMRegistryObject<MenuType<?>, MenuType<TestBarrelTankContainerMenu>> TEST_BARREL_TANK_MENU = MENU_TYPES.register("test_barrel_tank", () -> IMenuTypeExtension.create((IContainerFactory)new IContainerFactory<TestBarrelTankContainerMenu>(){

        public TestBarrelTankContainerMenu create(int windowId, Inventory inv, FriendlyByteBuf data) {
            return new TestBarrelTankContainerMenu(windowId, inv, data);
        }

        public TestBarrelTankContainerMenu create(int windowId, Inventory inv) {
            if (SFMEnvironmentUtils.isClient()) {
                BlockEntity be = ClientRayCastHelpers.getLookBlockEntity();
                if (!(be instanceof TestBarrelTankBlockEntity)) {
                    return (TestBarrelTankContainerMenu)super.create(windowId, inv);
                }
                TestBarrelTankBlockEntity blockEntity = (TestBarrelTankBlockEntity)be;
                return new TestBarrelTankContainerMenu(windowId, inv, blockEntity);
            }
            return (TestBarrelTankContainerMenu)super.create(windowId, inv);
        }
    }));

    public static void register(IEventBus bus) {
        MENU_TYPES.register(bus);
    }
}

