/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.block.BufferBlock;
import ca.teamdman.sfm.common.blockentity.BufferBlockEntityContents;
import ca.teamdman.sfm.common.capability.SFMWellKnownCapabilities;
import ca.teamdman.sfm.common.registry.SFMRegistryWrapper;
import ca.teamdman.sfm.common.registry.SFMWellKnownRegistries;
import ca.teamdman.sfm.common.resourcetype.RegistryBackedResourceType;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemResourceType
extends RegistryBackedResourceType<ItemStack, Item, IItemHandler> {
    public ItemResourceType() {
        super(SFMWellKnownCapabilities.ITEM_HANDLER);
    }

    @Override
    public SFMRegistryWrapper<Item> getRegistry() {
        return SFMWellKnownRegistries.ITEMS;
    }

    @Override
    public Item getItem(ItemStack itemStack) {
        return itemStack.getItem();
    }

    @Override
    public ItemStack copy(ItemStack stack) {
        return stack.copy();
    }

    @Override
    public IItemHandler createHandlerForBufferBlock(final BufferBlockEntityContents contents) {
        return new ItemStackHandler(contents.tier.numSlots){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                boolean isValid;
                boolean bl = isValid = !this.getStackInSlot(0).isEmpty() || contents.isEmpty();
                if (isValid) {
                    contents.lastUsedResource = BufferBlock.ContainedResource.Item;
                }
                return isValid;
            }
        };
    }

    @Override
    public long getAmount(ItemStack stack) {
        return stack.getCount();
    }

    @Override
    public ItemStack getStackInSlot(IItemHandler cap, int slot) {
        return cap.getStackInSlot(slot);
    }

    @Override
    public ItemStack extract(IItemHandler handler, int slot, long amount, boolean simulate) {
        int finalAmount = amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
        return handler.extractItem(slot, finalAmount, simulate);
    }

    @Override
    public boolean matchesStackType(Object o) {
        return o instanceof ItemStack;
    }

    @Override
    public boolean matchesCapabilityHandler(Object o) {
        return o instanceof IItemHandler;
    }

    @Override
    public Stream<ResourceLocation> getTagsForStack(ItemStack itemStack) {
        Block block;
        Stream blockTagKeys = !itemStack.isEmpty() ? ((block = Block.byItem((Item)itemStack.getItem())) != Blocks.AIR ? block.builtInRegistryHolder().tags() : Stream.empty()) : Stream.empty();
        Stream itemTagKeys = itemStack.getItem().builtInRegistryHolder().tags();
        return Stream.concat(itemTagKeys, blockTagKeys).map(TagKey::location);
    }

    @Override
    public int getSlots(IItemHandler handler) {
        return handler.getSlots();
    }

    @Override
    public long getMaxStackSize(ItemStack itemStack) {
        return itemStack.getMaxStackSize();
    }

    @Override
    public long getMaxStackSizeForSlot(IItemHandler handler, int slot) {
        return handler.getSlotLimit(slot);
    }

    @Override
    public ItemStack insert(IItemHandler handler, int slot, ItemStack stack, boolean simulate) {
        if (!simulate) {
            return handler.insertItem(slot, stack, false);
        }
        int grace = 40960;
        int count = stack.getCount();
        if (count > Integer.MAX_VALUE - grace) {
            stack.setCount(Integer.MAX_VALUE - grace);
            ItemStack rtn = handler.insertItem(slot, stack, true);
            stack.setCount(count);
            if (rtn.isEmpty()) {
                rtn = this.copy(stack);
                rtn.setCount(grace);
            } else {
                rtn.grow(grace);
            }
            return rtn;
        }
        return handler.insertItem(slot, stack, true);
    }

    @Override
    public boolean isEmpty(ItemStack stack) {
        return stack.isEmpty();
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.EMPTY;
    }

    @Override
    protected ItemStack setCount(ItemStack stack, long amount) {
        stack.setCount((int)Math.min(amount, Integer.MAX_VALUE));
        return stack;
    }
}

