/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.jei;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.jei.FallingAnvilDisenchantRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilExperienceShardRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilFormRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilRecipe;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollection;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentCollectionKind;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentEntry;
import ca.teamdman.sfm.common.enchantment.SFMEnchantmentKey;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMWellKnownRegistries;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMComponentUtils;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class FallingAnvilJEICategory
implements IRecipeCategory<FallingAnvilRecipe> {
    public static final RecipeType<FallingAnvilRecipe> RECIPE_TYPE = RecipeType.create((String)"sfm", (String)"falling_anvil", FallingAnvilRecipe.class);
    @MCVersionDependentBehaviour
    private final IDrawable background;
    private final IDrawable icon;

    public FallingAnvilJEICategory(IJeiHelpers jeiHelpers) {
        this.background = jeiHelpers.getGuiHelper().createBlankDrawable(this.getWidth(), this.getHeight());
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50322_));
    }

    public RecipeType<FallingAnvilRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return LocalizationKeys.FALLING_ANVIL_JEI_CATEGORY_TITLE.getComponent();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public int getWidth() {
        return 80;
    }

    public int getHeight() {
        return 54;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public static Stream<SFMEnchantmentKey> streamEnchantments() {
        return StreamSupport.stream(SFMWellKnownRegistries.ENCHANTMENTS.values().spliterator(), false).map(SFMEnchantmentKey::new);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FallingAnvilRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> anvil = List.of(new ItemStack((ItemLike)Items.f_42146_), new ItemStack((ItemLike)Items.f_42147_), new ItemStack((ItemLike)Items.f_42148_));
        if (recipe instanceof FallingAnvilFormRecipe) {
            FallingAnvilFormRecipe formRecipe = (FallingAnvilFormRecipe)recipe;
            builder.addSlot(RecipeIngredientRole.CATALYST, 0, 0).addItemStacks(anvil);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addIngredients(formRecipe.PARENT.form());
            ItemStack ironBlock = new ItemStack((ItemLike)Blocks.f_50075_);
            SFMComponentUtils.appendLore(ironBlock, new Component[]{LocalizationKeys.FALLING_ANVIL_JEI_CONSUMED.getComponent()});
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 36).addItemStack(ironBlock);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStacks(Arrays.stream(formRecipe.PARENT.form().m_43908_()).map(FormItem::createFormFromReference).toList());
        } else if (recipe instanceof FallingAnvilDisenchantRecipe) {
            SFMEnchantmentCollection seekingEnchantments = new SFMEnchantmentCollection();
            ArrayList<ItemStack> enchantedInputItems = new ArrayList<ItemStack>();
            focuses.getFocuses(RecipeIngredientRole.INPUT).map(FallingAnvilJEICategory::getIngredientItemStack).filter(Predicate.not(ItemStack::m_41619_)).forEach(inputItemStack -> {
                SFMEnchantmentCollection itemEnchantments = SFMEnchantmentCollection.fromItemStack(inputItemStack, SFMEnchantmentCollectionKind.EnchantedLikeATool);
                if (itemEnchantments.isEmpty()) {
                    return;
                }
                seekingEnchantments.addAll(itemEnchantments);
                enchantedInputItems.add((ItemStack)inputItemStack);
            });
            if (enchantedInputItems.isEmpty()) {
                List<Item> defaultTools = List.of(Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42390_, Items.f_42389_, Items.f_42391_, Items.f_42392_, Items.f_42388_, Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_, Items.f_42432_, Items.f_42431_, Items.f_42433_, Items.f_42434_, Items.f_42430_, Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_, Items.f_42385_, Items.f_42384_, Items.f_42386_, Items.f_42387_, Items.f_42383_, Items.f_42407_, Items.f_42408_, Items.f_42462_, Items.f_42463_, Items.f_42464_, Items.f_42465_, Items.f_42466_, Items.f_42467_, Items.f_42422_, Items.f_42421_, Items.f_42423_, Items.f_42424_, Items.f_42420_, Items.f_42411_, Items.f_42717_, Items.f_42713_, Items.f_42523_, Items.f_42398_);
                for (Item defaultTool : defaultTools) {
                    enchantedInputItems.add(new ItemStack((ItemLike)defaultTool));
                }
            }
            focuses.getFocuses(RecipeIngredientRole.OUTPUT).map(FallingAnvilJEICategory::getIngredientItemStack).filter(Predicate.not(ItemStack::m_41619_)).map(stack -> SFMEnchantmentCollection.fromItemStack(stack, SFMEnchantmentCollectionKind.HoldingLikeABook)).flatMap(Collection::stream).forEach(seekingEnchantments::add);
            boolean showingAllEnchantments = seekingEnchantments.isEmpty();
            ArrayList<ItemStack> inputEnchantedItemIngredients = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputEnchantedBookIngredients = new ArrayList<ItemStack>();
            Iterable holders = FallingAnvilJEICategory.streamEnchantments()::iterator;
            for (SFMEnchantmentKey enchantmentKey : holders) {
                int maxLevel = enchantmentKey.getMaxLevel();
                IntArraySet enchantmentLevelsToDisplay = new IntArraySet();
                if (showingAllEnchantments) {
                    for (level = 1; level <= maxLevel; ++level) {
                        enchantmentLevelsToDisplay.add(level);
                    }
                } else {
                    level = seekingEnchantments.getLevel(enchantmentKey);
                    if (level <= 0) continue;
                    enchantmentLevelsToDisplay.add(level);
                }
                if (enchantmentLevelsToDisplay.isEmpty()) continue;
                int[] levelsToDisplayIntArray = enchantmentLevelsToDisplay.toIntArray();
                for (ItemStack checkStack : enchantedInputItems) {
                    if (!enchantmentKey.canEnchant(checkStack) && checkStack.m_41720_() != Items.f_42398_) continue;
                    for (int level : levelsToDisplayIntArray) {
                        ItemStack toolStack = checkStack.m_41777_();
                        SFMEnchantmentEntry enchantment = new SFMEnchantmentEntry(enchantmentKey, level);
                        SFMEnchantmentCollection collection = new SFMEnchantmentCollection();
                        collection.add(enchantment);
                        collection.write(toolStack, SFMEnchantmentCollectionKind.EnchantedLikeATool);
                        ItemStack enchantedBook = enchantment.createEnchantedBook();
                        outputEnchantedBookIngredients.add(enchantedBook);
                        inputEnchantedItemIngredients.add(toolStack);
                    }
                }
            }
            builder.addSlot(RecipeIngredientRole.CATALYST, 8, 0).addItemStacks(anvil);
            ItemStack obsidian = new ItemStack((ItemLike)Blocks.f_50080_);
            SFMComponentUtils.appendLore(obsidian, new Component[]{LocalizationKeys.FALLING_ANVIL_JEI_NOT_CONSUMED.getComponent()});
            builder.addSlot(RecipeIngredientRole.CATALYST, 8, 36).addItemStack(obsidian);
            builder.addSlot(RecipeIngredientRole.INPUT, 18, 18).addItemStack(new ItemStack((ItemLike)Items.f_42517_));
            IRecipeSlotBuilder inputEnchantedItemSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addItemStacks(inputEnchantedItemIngredients);
            IRecipeSlotBuilder outputEnchantedBookSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStacks(outputEnchantedBookIngredients);
            if (inputEnchantedItemIngredients.size() == outputEnchantedBookIngredients.size()) {
                builder.createFocusLink(new IIngredientAcceptor[]{inputEnchantedItemSlot, outputEnchantedBookSlot});
            } else {
                SFM.LOGGER.warn("Input and output ingredient counts do not match! This should not happen!");
            }
        } else if (recipe instanceof FallingAnvilExperienceShardRecipe) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 0, 0).addItemStacks(anvil);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42690_}));
            ItemStack obsidian = new ItemStack((ItemLike)Blocks.f_50080_);
            SFMComponentUtils.appendLore(obsidian, new Component[]{LocalizationKeys.FALLING_ANVIL_JEI_NOT_CONSUMED.getComponent()});
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 36).addItemStack(obsidian);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStack(new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get()));
        }
    }

    @MCVersionDependentBehaviour
    private static ItemStack getIngredientItemStack(IFocus<?> focus) {
        return focus.getTypedValue().getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.f_41583_);
    }
}

