/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.cablenetwork.SFMBlockCapabilityCacheForLevel;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityDiscovery;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CableNetwork {
    protected final Level level;
    protected final LongSet cablePositions = new LongOpenHashSet();
    protected final SFMBlockCapabilityCacheForLevel levelCapabilityCache;

    public CableNetwork(Level level) {
        this.level = level;
        this.levelCapabilityCache = new SFMBlockCapabilityCacheForLevel(level);
    }

    public SFMBlockCapabilityCacheForLevel getLevelCapabilityCache() {
        return this.levelCapabilityCache;
    }

    public static boolean isCable(@Nullable Level world, @NotStored BlockPos cablePos) {
        if (world == null) {
            return false;
        }
        return world.m_8055_(cablePos).m_60734_() instanceof ICableBlock;
    }

    public void rebuildNetwork(@NotStored BlockPos start) {
        this.cablePositions.clear();
        this.levelCapabilityCache.clear();
        CableNetwork.discoverCables(this.getLevel(), start).forEach(this::addCable);
    }

    public void rebuildNetworkFromCache(@NotStored BlockPos start, CableNetwork other) {
        this.cablePositions.clear();
        this.levelCapabilityCache.clear();
        List cables = SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
            for (Direction d : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                target.m_122190_((Vec3i)current).m_122173_(d);
                if (!other.containsCablePosition((BlockPos)target)) continue;
                next.accept(target.m_7949_());
            }
        }, start).toList();
        for (BlockPos cablePos : cables) {
            this.cablePositions.add(cablePos.m_121878_());
        }
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        LongOpenHashSet seenCapabilityPositions = new LongOpenHashSet();
        for (BlockPos cablePos : cables) {
            for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                target.m_122190_((Vec3i)cablePos).m_122173_(direction);
                boolean firstVisit = seenCapabilityPositions.add(target.m_121878_());
                if (!firstVisit) continue;
                this.levelCapabilityCache.overwriteFromOther((BlockPos)target, other.levelCapabilityCache);
            }
        }
    }

    public static Stream<BlockPos> discoverCables(Level level, @NotStored BlockPos startPos) {
        return SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
            for (Direction d : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                target.m_122190_((Vec3i)current).m_122173_(d);
                if (!CableNetwork.isCable(level, (BlockPos)target)) continue;
                next.accept(target.m_7949_());
            }
        }, startPos);
    }

    public void addCable(@NotStored BlockPos pos) {
        this.cablePositions.add(pos.m_121878_());
    }

    public Level getLevel() {
        return this.level;
    }

    public String toString() {
        return "CableNetwork{level=" + this.getLevel().m_46472_().m_135782_() + ", #cables=" + this.getCableCount() + ", #cache=" + this.levelCapabilityCache.size() + "}";
    }

    public boolean isAdjacentToCable(@NotStored BlockPos pos) {
        if (this.containsCablePosition(pos)) {
            return true;
        }
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.m_122190_((Vec3i)pos).m_122173_(direction);
            if (!this.containsCablePosition((BlockPos)target)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCablePosition(@NotStored BlockPos pos) {
        return this.cablePositions.contains(pos.m_121878_());
    }

    @MCVersionDependentBehaviour
    @NotNull
    public <CAP> SFMBlockCapabilityResult<CAP> getCapability(SFMBlockCapabilityKind<CAP> capKind, @NotStored BlockPos pos, @Nullable Direction direction, TranslatableLogger logger) {
        return SFMBlockCapabilityDiscovery.discoverCapabilityFromNetwork(this, capKind, pos, direction, logger);
    }

    public int getCableCount() {
        return this.cablePositions.size();
    }

    public void mergeNetwork(CableNetwork other) {
        this.cablePositions.addAll((LongCollection)other.cablePositions);
        this.levelCapabilityCache.putAll(other.levelCapabilityCache);
    }

    public boolean isEmpty() {
        return this.cablePositions.isEmpty();
    }

    public Stream<BlockPos> getCablePositions() {
        return this.cablePositions.longStream().mapToObj(BlockPos::m_122022_);
    }

    public LongSet getCablePositionsRaw() {
        return this.cablePositions;
    }

    public Stream<BlockPos> getCapabilityProviderPositions() {
        return this.levelCapabilityCache.getPositions();
    }

    public void bustCacheForChunk(ChunkAccess chunkAccess) {
        this.levelCapabilityCache.bustCacheForChunk(chunkAccess);
    }

    protected List<CableNetwork> withoutCable(@NotStored BlockPos cablePos) {
        this.cablePositions.remove(cablePos.m_121878_());
        ArrayList<CableNetwork> branches = new ArrayList<CableNetwork>();
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.m_122190_((Vec3i)cablePos).m_122173_(direction);
            if (!this.containsCablePosition((BlockPos)target) || branches.stream().anyMatch(n -> n.containsCablePosition((BlockPos)target))) continue;
            CableNetwork branchNetwork = new CableNetwork(this.getLevel());
            branchNetwork.rebuildNetworkFromCache((BlockPos)target, this);
            branches.add(branchNetwork);
        }
        return branches;
    }
}

