/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.capability.ae2;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.blockentity.misc.InterfaceBlockEntity;
import appeng.capabilities.Capabilities;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.capability.SFMWellKnownCapabilities;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMItemUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.function.Function;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterfaceCapabilityProvider
implements SFMBlockCapabilityProvider<Object> {
    @Override
    public boolean matchesCapabilityKind(SFMBlockCapabilityKind<?> capabilityKind) {
        return SFMWellKnownCapabilities.ITEM_HANDLER.equals(capabilityKind) || SFMWellKnownCapabilities.FLUID_HANDLER.equals(capabilityKind);
    }

    @Override
    public SFMBlockCapabilityResult<Object> getCapability(SFMBlockCapabilityKind<Object> capabilityKind, LevelAccessor level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable Direction direction) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof InterfaceBlockEntity)) {
            return null;
        }
        InterfaceBlockEntity in = (InterfaceBlockEntity)be;
        if (!in.getConfig().isEmpty() || in.getMainNode() == null || in.getGridNode() == null || !in.getGridNode().isActive()) {
            return null;
        }
        return SFMBlockCapabilityResult.of(be.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR).lazyMap(aeHandler -> new InterfaceHandler(level, pos)).cast());
    }

    @Nullable
    private static InterfaceBlockEntity interfaceAt(LevelAccessor level, @NotStored BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof InterfaceBlockEntity) {
            InterfaceBlockEntity in = (InterfaceBlockEntity)be;
            return in;
        }
        return null;
    }

    @MethodsReturnNonnullByDefault
    record InterfaceHandler(LevelAccessor level, BlockPos pos) implements IItemHandler,
    IFluidHandler
    {
        public int getSlots() {
            Integer slots = this.withStorage(s -> {
                int i = 0;
                for (Object2LongMap.Entry stored : s.getAvailableStacks()) {
                    if (!(stored.getKey() instanceof AEItemKey)) continue;
                    ++i;
                }
                return i;
            });
            if (slots == null) {
                slots = this.withBaseItemHandler(IItemHandler::getSlots);
            }
            return slots == null ? 0 : slots;
        }

        public ItemStack getStackInSlot(int slot) {
            ItemStack stack = this.withStorage(s -> {
                int i = 0;
                for (Object2LongMap.Entry stored : s.getAvailableStacks()) {
                    Object patt4377$temp = stored.getKey();
                    if (!(patt4377$temp instanceof AEItemKey)) continue;
                    AEItemKey key = (AEItemKey)patt4377$temp;
                    if (slot != i++) continue;
                    return key.toStack((int)Math.min(Integer.MAX_VALUE, stored.getLongValue()));
                }
                return ItemStack.f_41583_;
            });
            if (stack == null) {
                stack = this.withBaseItemHandler(c -> c.getStackInSlot(slot));
            }
            return stack == null ? ItemStack.f_41583_ : stack;
        }

        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            Integer inserted = this.withStorage(s -> {
                AEItemKey key = AEItemKey.of((ItemStack)stack);
                if (key == null) {
                    return 0;
                }
                IEnergyService energy = this.getEnergy();
                if (energy == null) {
                    return 0;
                }
                return (int)StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)s, (AEKey)key, (long)stack.m_41613_(), (IActionSource)IActionSource.empty(), (Actionable)(simulate ? Actionable.SIMULATE : Actionable.MODULATE));
            });
            if (inserted == null) {
                ItemStack stack2 = this.withBaseItemHandler(c -> c.insertItem(slot, stack, simulate));
                return stack2 == null ? ItemStack.f_41583_ : stack2;
            }
            if (!simulate) {
                stack.m_41774_(inserted.intValue());
                return stack;
            }
            ItemStack rtn = stack.m_41777_();
            rtn.m_41774_(inserted.intValue());
            return rtn;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = this.withStorage(s -> {
                int i = 0;
                for (Object2LongMap.Entry stored : s.getAvailableStacks()) {
                    Object patt6640$temp = stored.getKey();
                    if (!(patt6640$temp instanceof AEItemKey)) continue;
                    AEItemKey key = (AEItemKey)patt6640$temp;
                    if (slot != i++) continue;
                    IEnergyService energy = this.getEnergy();
                    if (energy == null) {
                        return ItemStack.f_41583_;
                    }
                    int extracted = (int)StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)s, (AEKey)key, (long)amount, (IActionSource)IActionSource.empty(), (Actionable)(simulate ? Actionable.SIMULATE : Actionable.MODULATE));
                    return key.toStack(extracted);
                }
                return ItemStack.f_41583_;
            });
            if (stack == null) {
                stack = this.withBaseItemHandler(c -> c.extractItem(slot, amount, simulate));
            }
            return stack == null ? ItemStack.f_41583_ : stack;
        }

        public int getSlotLimit(int slot) {
            return this.getStackInSlot(slot).m_41741_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return SFMItemUtils.isSameItemSameTags(this.getStackInSlot(slot), stack);
        }

        public int getTanks() {
            Integer slots = this.withStorage(s -> {
                int i = 0;
                for (Object2LongMap.Entry stored : s.getAvailableStacks()) {
                    if (!(stored.getKey() instanceof AEFluidKey)) continue;
                    ++i;
                }
                return i;
            });
            if (slots == null) {
                slots = this.withBaseFluidHandler(IFluidHandler::getTanks);
            }
            return slots == null ? 0 : slots;
        }

        public FluidStack getFluidInTank(int tank) {
            FluidStack stack = this.withStorage(s -> {
                int i = 0;
                for (Object2LongMap.Entry stored : s.getAvailableStacks()) {
                    Object patt8889$temp = stored.getKey();
                    if (!(patt8889$temp instanceof AEFluidKey)) continue;
                    AEFluidKey key = (AEFluidKey)patt8889$temp;
                    if (tank != i++) continue;
                    return key.toStack((int)Math.min(Integer.MAX_VALUE, stored.getLongValue()));
                }
                return FluidStack.EMPTY;
            });
            if (stack == null) {
                stack = this.withBaseFluidHandler(c -> c.getFluidInTank(tank));
            }
            return stack == null ? FluidStack.EMPTY : stack;
        }

        public int getTankCapacity(int tank) {
            if (this.getCapability().isPresent()) {
                return Integer.MAX_VALUE;
            }
            Integer capacity = this.withBaseFluidHandler(c -> c.getTankCapacity(tank));
            return capacity == null ? 0 : capacity;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            if (this.getCapability().isPresent()) {
                return this.getFluidInTank(tank).isFluidEqual(stack);
            }
            Boolean valid = this.withBaseFluidHandler(c -> c.isFluidValid(tank, stack));
            return valid != null && valid != false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            Integer inserted = this.withStorage(s -> {
                AEFluidKey key = AEFluidKey.of((FluidStack)resource);
                if (key == null) {
                    return 0;
                }
                IEnergyService energy = this.getEnergy();
                if (energy == null) {
                    return 0;
                }
                int ins = (int)StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)s, (AEKey)key, (long)resource.getAmount(), (IActionSource)IActionSource.empty(), (Actionable)InterfaceHandler.fluidActionToActionable(action));
                if (!action.simulate()) {
                    resource.shrink(ins);
                }
                return ins;
            });
            if (inserted == null) {
                inserted = this.withBaseFluidHandler(c -> c.fill(resource, action));
            }
            return inserted == null ? 0 : inserted;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack stack = this.withStorage(s -> {
                AEFluidKey key = AEFluidKey.of((FluidStack)resource);
                if (key == null) {
                    return FluidStack.EMPTY;
                }
                IEnergyService energy = this.getEnergy();
                if (energy == null) {
                    return FluidStack.EMPTY;
                }
                int extracted = (int)StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)s, (AEKey)key, (long)resource.getAmount(), (IActionSource)IActionSource.empty(), (Actionable)InterfaceHandler.fluidActionToActionable(action));
                return key.toStack(extracted);
            });
            if (stack == null) {
                stack = this.withBaseFluidHandler(c -> c.drain(resource, action));
            }
            return stack == null ? FluidStack.EMPTY : stack;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack stack = this.withStorage(s -> {
                for (Object2LongMap.Entry stored : s.getAvailableStacks()) {
                    Object patt12596$temp = stored.getKey();
                    if (!(patt12596$temp instanceof AEFluidKey)) continue;
                    AEFluidKey key = (AEFluidKey)patt12596$temp;
                    IEnergyService energy = this.getEnergy();
                    if (energy == null) {
                        return FluidStack.EMPTY;
                    }
                    int extracted = (int)StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)s, (AEKey)key, (long)maxDrain, (IActionSource)IActionSource.empty(), (Actionable)InterfaceHandler.fluidActionToActionable(action));
                    return key.toStack(extracted);
                }
                return FluidStack.EMPTY;
            });
            if (stack == null) {
                stack = this.withBaseFluidHandler(c -> c.drain(maxDrain, action));
            }
            return stack == null ? FluidStack.EMPTY : stack;
        }

        private static Actionable fluidActionToActionable(IFluidHandler.FluidAction fluidAction) {
            return switch (fluidAction) {
                default -> throw new IncompatibleClassChangeError();
                case IFluidHandler.FluidAction.EXECUTE -> Actionable.MODULATE;
                case IFluidHandler.FluidAction.SIMULATE -> Actionable.SIMULATE;
            };
        }

        @Nullable
        InterfaceBlockEntity getInterface() {
            return InterfaceCapabilityProvider.interfaceAt(this.level, this.pos);
        }

        @Nullable
        IEnergyService getEnergy() {
            InterfaceBlockEntity in = this.getInterface();
            if (in == null) {
                return null;
            }
            IGrid grid = in.getMainNode().getGrid();
            if (grid == null) {
                return null;
            }
            return grid.getEnergyService();
        }

        LazyOptional<IStorageMonitorableAccessor> getCapability() {
            InterfaceBlockEntity in = this.getInterface();
            if (in == null) {
                return LazyOptional.empty();
            }
            if (!in.getConfig().isEmpty() || in.getMainNode() == null || in.getGridNode() == null || !in.getGridNode().isActive()) {
                return LazyOptional.empty();
            }
            return in.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR);
        }

        @Nullable
        <T> T withStorage(Function<MEStorage, T> callback) {
            LazyOptional<IStorageMonitorableAccessor> cap = this.getCapability();
            if (cap.isPresent()) {
                return callback.apply(cap.map(c -> c.getInventory(IActionSource.empty())).orElse(null));
            }
            return null;
        }

        @Nullable
        <T> T withBaseItemHandler(Function<IItemHandler, T> callback) {
            InterfaceBlockEntity in = this.getInterface();
            if (in == null) {
                return null;
            }
            LazyOptional maybeCap = in.getCapability(SFMWellKnownCapabilities.ITEM_HANDLER.capabilityKind());
            if (maybeCap.isPresent()) {
                return callback.apply((IItemHandler)maybeCap.orElse(null));
            }
            return null;
        }

        @Nullable
        <T> T withBaseFluidHandler(Function<IFluidHandler, T> callback) {
            InterfaceBlockEntity in = this.getInterface();
            if (in == null) {
                return null;
            }
            LazyOptional maybeCap = in.getCapability(SFMWellKnownCapabilities.FLUID_HANDLER.capabilityKind());
            if (maybeCap.isPresent()) {
                return callback.apply((IFluidHandler)maybeCap.orElse(null));
            }
            return null;
        }
    }
}

