/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.text_editor.SFMTextEditScreenDiskOpenContext;
import ca.teamdman.sfm.client.text_styling.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundDiskItemSetProgramPacket;
import ca.teamdman.sfm.common.program.linting.ProgramLinter;
import ca.teamdman.sfm.common.registry.SFMCreativeTabs;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import ca.teamdman.sfm.common.util.SFMItemUtils;
import ca.teamdman.sfm.common.util.SFMTranslationUtils;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiskItem
extends Item {
    public DiskItem() {
        super(new Item.Properties().m_41491_(SFMCreativeTabs.TAB));
    }

    public static String getProgramString(ItemStack stack) {
        return stack.m_41784_().m_128461_("sfm:program");
    }

    public static void setProgram(ItemStack stack, String program) {
        program = program.replaceAll("\r", "");
        stack.m_41784_().m_128359_("sfm:program", program);
    }

    public static void pruneIfDefault(ItemStack stack) {
        if (DiskItem.getProgramString(stack).isBlank() && LabelPositionHolder.from(stack).isEmpty()) {
            for (String key : (String[])stack.m_41784_().m_128431_().toArray(String[]::new)) {
                stack.m_41749_(key);
            }
        }
    }

    @Nullable
    public static Program compileAndUpdateErrorsAndWarnings(ItemStack stack, @Nullable ManagerBlockEntity manager, boolean updateWarnings) {
        if (manager != null) {
            manager.logger.info(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_FROM_DISK_BEGIN.get()));
        }
        AtomicReference<Object> rtn = new AtomicReference<Object>(null);
        String programString = DiskItem.getProgramString(stack);
        new ProgramBuilder(programString).build().caseSuccess((successProgram, metadata) -> {
            if (updateWarnings) {
                Collection<TranslatableContents> warnings = ProgramLinter.gatherWarnings(successProgram, LabelPositionHolder.from(stack), manager);
                if (manager != null) {
                    manager.logger.info(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_SUCCEEDED_WITH_WARNINGS.get(successProgram.name(), warnings.size())));
                    manager.logger.warn(warnings::forEach);
                }
                DiskItem.setWarnings(stack, warnings);
            }
            DiskItem.setProgramName(stack, successProgram.name());
            DiskItem.setErrors(stack, Collections.emptyList());
            rtn.set(successProgram);
        }).caseFailure(result -> {
            List<TranslatableContents> warnings = Collections.emptyList();
            List<TranslatableContents> errors = result.metadata().errors();
            if (manager != null) {
                manager.logger.error(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_FAILED_WITH_ERRORS.get(errors.size())));
                manager.logger.error(errors::forEach);
            }
            DiskItem.setWarnings(stack, warnings);
            DiskItem.setErrors(stack, errors);
        });
        return rtn.get();
    }

    public static List<TranslatableContents> getErrors(ItemStack stack) {
        return stack.m_41784_().m_128437_("sfm:errors", 10).stream().map(CompoundTag.class::cast).map(SFMTranslationUtils::deserializeTranslation).toList();
    }

    public static void setErrors(ItemStack stack, List<TranslatableContents> errors) {
        stack.m_41784_().m_128365_("sfm:errors", (Tag)errors.stream().map(SFMTranslationUtils::serializeTranslation).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
    }

    public static List<TranslatableContents> getWarnings(ItemStack stack) {
        return stack.m_41784_().m_128437_("sfm:warnings", 10).stream().map(CompoundTag.class::cast).map(SFMTranslationUtils::deserializeTranslation).collect(Collectors.toList());
    }

    public static void rebuildWarnings(ManagerBlockEntity manager) {
        Program program;
        ItemStack disk = manager.getDisk();
        if (disk != null && (program = manager.getProgram()) != null) {
            DiskItem.setWarnings(disk, ProgramLinter.gatherWarnings(program, LabelPositionHolder.from(disk), manager));
        }
    }

    public static void setWarnings(ItemStack stack, Collection<TranslatableContents> warnings) {
        stack.m_41784_().m_128365_("sfm:warnings", (Tag)warnings.stream().map(SFMTranslationUtils::serializeTranslation).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
    }

    public static String getProgramName(ItemStack stack) {
        return stack.m_41784_().m_128461_("sfm:name");
    }

    public static void setProgramName(ItemStack stack, String name) {
        if (stack.m_41720_() instanceof DiskItem) {
            stack.m_41784_().m_128359_("sfm:name", name);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            SFMScreenChangeHelpers.showProgramEditScreen(new SFMTextEditScreenDiskOpenContext(DiskItem.getProgramString(stack), LabelPositionHolder.from(stack), newProgramString -> SFMPackets.sendToServer(new ServerboundDiskItemSetProgramPacket((String)newProgramString, pUsedHand))));
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.m_5776_());
    }

    public Component m_7626_(ItemStack stack) {
        if (SFMEnvironmentUtils.isClient() && SFMKeyMappings.isKeyDown(SFMKeyMappings.MORE_INFO_TOOLTIP_KEY)) {
            return super.m_7626_(stack);
        }
        String name = DiskItem.getProgramName(stack);
        if (name.isEmpty()) {
            return super.m_7626_(stack);
        }
        return Component.m_237113_((String)name).m_130940_(ChatFormatting.AQUA);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag detail) {
        String program = DiskItem.getProgramString(stack);
        if (SFMItemUtils.isClientAndMoreInfoKeyPressed() && !program.isEmpty()) {
            lines.add((Component)SFMItemUtils.getRainbow(this.m_7626_(stack).getString().length()));
            lines.addAll(ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(program, false));
        } else {
            lines.addAll(LabelPositionHolder.from(stack).asHoverText());
            DiskItem.getErrors(stack).stream().map(MutableComponent::m_237204_).map(line -> line.m_130940_(ChatFormatting.RED)).forEach(lines::add);
            DiskItem.getWarnings(stack).stream().map(MutableComponent::m_237204_).map(line -> line.m_130940_(ChatFormatting.YELLOW)).forEach(lines::add);
            if (!program.isEmpty()) {
                SFMItemUtils.appendMoreInfoKeyReminderTextIfOnClient(lines);
            }
        }
        if (program.isEmpty()) {
            lines.add((Component)LocalizationKeys.DISK_EDIT_IN_HAND_TOOLTIP.getComponent().m_130940_(ChatFormatting.GRAY));
        }
    }
}

