/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.recipe;

import ca.teamdman.sfm.common.blockentity.PrintingPressBlockEntity;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.registry.SFMRecipeSerializers;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record PrintingPressRecipe(@MCVersionDependentBehaviour ResourceLocation id, Ingredient form, Ingredient ink, Ingredient paper) implements Recipe<PrintingPressBlockEntity>
{
    public boolean matches(PrintingPressBlockEntity pContainer, Level pLevel) {
        return this.paper.test(pContainer.getPaper()) && this.ink.test(pContainer.getInk()) && this.form.test(FormItem.getBorrowedReferenceFromForm(pContainer.getForm()));
    }

    @MCVersionDependentBehaviour
    public ItemStack assemble(PrintingPressBlockEntity pContainer) {
        ItemStack rtn = FormItem.getCopiedReferenceFromForm(pContainer.getForm());
        rtn.m_41764_(pContainer.getPaper().m_41613_());
        return rtn;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @MCVersionDependentBehaviour
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @MCVersionDependentBehaviour
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SFMRecipeSerializers.PRINTING_PRESS.get();
    }

    public RecipeType<?> m_6671_() {
        return SFMRecipeTypes.PRINTING_PRESS.get();
    }

    @Override
    @MCVersionDependentBehaviour
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PrintingPressRecipe that = (PrintingPressRecipe)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.form, that.form) && Objects.equals(this.ink, that.ink) && Objects.equals(this.paper, that.paper);
    }

    @Override
    @MCVersionDependentBehaviour
    public int hashCode() {
        return Objects.hash(this.id, this.form, this.ink, this.paper);
    }

    @Override
    public String toString() {
        return "PrintingPressRecipe[id=" + this.id + ", form=" + this.form + ", ink=" + this.ink + ", paper=" + this.paper + "]";
    }

    @MCVersionDependentBehaviour
    public static class Serializer
    implements RecipeSerializer<PrintingPressRecipe> {
        public PrintingPressRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            Ingredient form = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("form"));
            Ingredient ink = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("ink"));
            Ingredient paper = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("paper"));
            return new PrintingPressRecipe(pRecipeId, form, ink, paper);
        }

        @Nullable
        public PrintingPressRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient form = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ink = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient paper = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            return new PrintingPressRecipe(pRecipeId, form, ink, paper);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PrintingPressRecipe pRecipe) {
            pRecipe.form.m_43923_(pBuffer);
            pRecipe.ink.m_43923_(pBuffer);
            pRecipe.paper.m_43923_(pBuffer);
        }
    }
}

