/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;

@MCVersionDependentBehaviour
public final class SFMRegistryWrapper<T>
implements Iterable<T> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    @Nullable
    private IForgeRegistry<T> maybeInner;
    @Nullable
    private Registry<T> maybeInnerVanilla;

    public SFMRegistryWrapper(@MCVersionDependentBehaviour IForgeRegistry<T> inner) {
        this.maybeInner = inner;
        this.registryKey = inner.getRegistryKey();
    }

    public SFMRegistryWrapper(ResourceKey<? extends Registry<T>> registryKey) {
        this.maybeInner = null;
        this.registryKey = registryKey;
    }

    @MCVersionDependentBehaviour
    @Nullable
    public T get(ResourceLocation resourceTypeId) {
        return (T)this.getInnerRegistry().getValue(resourceTypeId);
    }

    @MCVersionDependentBehaviour
    public Set<ResourceLocation> keys() {
        return this.getInnerRegistry().getKeys();
    }

    public Iterable<T> values() {
        return this.getInnerRegistry();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.getInnerRegistry().spliterator(), false);
    }

    public Stream<Holder.Reference<T>> holders() {
        Registry<T> registry = this.getVanillaRegistry();
        if (registry instanceof MappedRegistry) {
            MappedRegistry mappedRegistry = (MappedRegistry)registry;
            return mappedRegistry.m_203611_();
        }
        return Stream.empty();
    }

    @Nullable
    public ResourceLocation getId(T value) {
        return this.getInnerRegistry().getKey(value);
    }

    public Optional<ResourceKey<T>> getKey(T value) {
        return this.getInnerRegistry().getResourceKey(value);
    }

    @MCVersionDependentBehaviour
    public Set<Map.Entry<ResourceKey<T>, T>> entries() {
        return this.getInnerRegistry().getEntries();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getInnerRegistry().iterator();
    }

    public ResourceKey<? extends Registry<T>> registryKey() {
        return this.registryKey;
    }

    public boolean contains(ResourceLocation location) {
        return this.getInnerRegistry().containsKey(location);
    }

    @MCVersionDependentBehaviour
    public IForgeRegistry<T> getInnerRegistry() {
        if (this.maybeInner == null) {
            this.maybeInner = RegistryManager.ACTIVE.getRegistry(this.registryKey);
        }
        return this.maybeInner;
    }

    @MCVersionDependentBehaviour
    public Registry<T> getVanillaRegistry() {
        if (this.maybeInnerVanilla != null) {
            return this.maybeInnerVanilla;
        }
        this.maybeInnerVanilla = (Registry)BuiltinRegistries.f_123858_.m_6246_(this.registryKey);
        if (this.maybeInnerVanilla != null) {
            return this.maybeInnerVanilla;
        }
        if (!SFMEnvironmentUtils.isClient()) {
            throw new IllegalStateException("Failed to acquire registry " + this.registryKey + " - not present in the registry registry, and we aren't on the client");
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            throw new IllegalStateException("Failed to acquire registry " + this.registryKey + " - client level is null?");
        }
        this.maybeInnerVanilla = level.m_5962_().m_175515_(this.registryKey);
        return this.maybeInnerVanilla;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SFMRegistryWrapper that = (SFMRegistryWrapper)obj;
        return Objects.equals(this.getInnerRegistry(), that.getInnerRegistry());
    }

    public int hashCode() {
        return Objects.hash(this.getInnerRegistry());
    }

    public String toString() {
        return "SFMRegistryWrapper[inner=" + this.maybeInner + "]";
    }

    public HolderLookup.RegistryLookup<T> asHolderLookup() {
        return new HolderLookup.RegistryLookup(this.getVanillaRegistry());
    }
}

