/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.block.BufferBlockTier;
import ca.teamdman.sfm.common.blockentity.BufferBlockEntity;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BufferBlock
extends BaseEntityBlock {
    public static final EnumProperty<ContainedResource> CONTAINED_RESOURCE = EnumProperty.m_61587_((String)"resource", ContainedResource.class);
    public final BufferBlockTier tier;

    public BufferBlock(BlockBehaviour.Properties pProperties, BufferBlockTier tier) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(CONTAINED_RESOURCE, (Comparable)((Object)ContainedResource.Item)));
        this.tier = tier;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return SFMBlockEntities.BUFFER_BLOCK_ENTITY.get().m_155264_(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_(CONTAINED_RESOURCE, (Comparable)((Object)ContainedResource.Unknown));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return BufferBlock.m_152132_(pBlockEntityType, SFMBlockEntities.BUFFER_BLOCK_ENTITY.get(), BufferBlockEntity::serverTick);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{CONTAINED_RESOURCE});
    }

    public static enum ContainedResource implements StringRepresentable
    {
        Item,
        Fluid,
        Energy,
        Chemical,
        Redstone,
        Unknown;


        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case Item -> "item";
                case Fluid -> "fluid";
                case Energy -> "energy";
                case Chemical -> "chemical";
                case Redstone -> "redstone";
                case Unknown -> "unknown";
            };
        }

        public static ContainedResource from(ResourceType<?, ?, ?> resourceType) {
            String name = Objects.requireNonNull(SFMResourceTypes.registry().getId(resourceType)).m_135815_();
            if (name.equals("item")) {
                return Item;
            }
            if (name.equals("fluid")) {
                return Fluid;
            }
            if (name.equals("forge_energy")) {
                return Energy;
            }
            if (name.equals("redstone")) {
                return Redstone;
            }
            if (SFMModCompat.isMekanismLoaded()) {
                if (name.equals("gas") || name.equals("infusion") || name.equals("pigment") || name.equals("slurry")) {
                    return Chemical;
                }
                if (name.equals("mekanism_energy")) {
                    return Energy;
                }
            }
            return Unknown;
        }
    }
}

