/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.ActuallyUseableDirectionalBlock;
import com.bigdious.risus.blocks.AshenSpireBlock;
import com.bigdious.risus.blocks.entity.BiomeBlockEntity;
import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.init.RisusBiomes;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusTags;
import com.bigdious.risus.util.ServerParticleUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BiomeBlock
extends ActuallyUseableDirectionalBlock
implements SimpleMultiloggedBlock,
EntityBlock {
    public static final BooleanProperty SPREADING = BooleanProperty.create((String)"spreading");
    public static final BooleanProperty SPREADING_MORK = BooleanProperty.create((String)"spreading_mork");
    public static final BooleanProperty SPREADING_FEIGR = BooleanProperty.create((String)"spreading_feigr");
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.UP, (Object)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (Object)Direction.DOWN, (Object)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (Object)Direction.WEST, (Object)Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (Object)Direction.NORTH, (Object)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0)));

    public BiomeBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f).sound(SoundType.BAMBOO));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SPREADING, (Comparable)Boolean.valueOf(false))).setValue((Property)SPREADING_MORK, (Comparable)Boolean.valueOf(false))).setValue((Property)SPREADING_FEIGR, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.UP)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABBS.get(state.getValue((Property)FACING));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SPREADING}).add(new Property[]{SPREADING_FEIGR}).add(new Property[]{SPREADING_MORK}).add(new Property[]{FLUIDLOGGED});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        Direction clicked = context.getClickedFace();
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clicked)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
        if (this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos())) {
            return state;
        }
        for (Direction dir : context.getNearestLookingDirections()) {
            state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir.getOpposite())).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
            if (!this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return state;
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        if (!this.canSurvive(state, (LevelReader)accessor, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 20);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BiomeBlockEntity laughingStalk;
        if (!(((Boolean)state.getValue((Property)SPREADING)).booleanValue() || ((Boolean)state.getValue((Property)SPREADING_MORK)).booleanValue() || ((Boolean)state.getValue((Property)SPREADING_FEIGR)).booleanValue())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BiomeBlockEntity) {
            laughingStalk = (BiomeBlockEntity)blockEntity;
            if ((Boolean)state.getValue((Property)SPREADING_FEIGR) != false ? laughingStalk.decaytime > 170 : ((Boolean)state.getValue((Property)SPREADING_MORK) != false ? laughingStalk.decaytime > 50 : laughingStalk.decaytime > 80)) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)SPREADING, (Comparable)Boolean.valueOf(false))).setValue((Property)SPREADING_FEIGR, (Comparable)Boolean.valueOf(false))).setValue((Property)SPREADING_MORK, (Comparable)Boolean.valueOf(false)));
                laughingStalk.decaytime = 0;
            }
        }
        if ((((Boolean)state.getValue((Property)SPREADING)).booleanValue() || ((Boolean)state.getValue((Property)SPREADING_FEIGR)).booleanValue() || ((Boolean)state.getValue((Property)SPREADING_MORK)).booleanValue()) && (blockEntity = level.getBlockEntity(pos)) instanceof BiomeBlockEntity) {
            laughingStalk = (BiomeBlockEntity)blockEntity;
            ++laughingStalk.decaytime;
        }
        this.performConversion(level, pos, rand, state);
        level.scheduleTick(pos, (Block)this, 20);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!(((Boolean)state.getValue((Property)SPREADING)).booleanValue() || ((Boolean)state.getValue((Property)SPREADING_MORK)).booleanValue() || ((Boolean)state.getValue((Property)SPREADING_FEIGR)).booleanValue())) {
            if (stack.is(RisusItems.ORGANIC_MATTER)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SPREADING, (Comparable)Boolean.valueOf(true)));
            } else if (stack.is(RisusItems.MUSIC_DISC_MORK)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SPREADING_MORK, (Comparable)Boolean.valueOf(true)));
            } else if (stack.is(RisusItems.MUSIC_DISC_FEIGR)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SPREADING_FEIGR, (Comparable)Boolean.valueOf(true)));
            } else {
                return ItemInteractionResult.FAIL;
            }
            level.scheduleTick(pos, (Block)this, 20);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    void performConversion(ServerLevel level, BlockPos pos, RandomSource rand, BlockState state) {
        int i;
        Holder.Reference biome = level.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow((Boolean)state.getValue((Property)SPREADING_MORK) != false ? RisusBiomes.COALIFICATION_MORK : ((Boolean)state.getValue((Property)SPREADING_FEIGR) != false ? RisusBiomes.COALIFICATION_FEIGR : RisusBiomes.COALIFICATION));
        int range = (Boolean)state.getValue((Property)SPREADING_FEIGR) != false ? 20 : ((Boolean)state.getValue((Property)SPREADING_MORK) != false ? 9 : 12);
        for (i = 0; i < 3; ++i) {
            int dz;
            int dy;
            int rangeDownscaled = range - 3;
            int dx = rand.nextInt(rangeDownscaled * 2 + 1) - rangeDownscaled;
            BlockPos blockpos = pos.offset(dx, dy = rand.nextInt(rangeDownscaled * 2 + 1) - rangeDownscaled, dz = rand.nextInt(rangeDownscaled * 2 + 1) - rangeDownscaled);
            BlockState blockstate = level.getBlockState(blockpos);
            if (!blockstate.is(RisusTags.Blocks.SPAWN_SPIRE_ON) || !level.getBlockState(blockpos.above()).canBeReplaced() || !level.getBlockState(blockpos.above(2)).canBeReplaced()) continue;
            level.setBlock(blockpos.above(), ((Block)RisusBlocks.ASHEN_SPIRE.get()).defaultBlockState(), 3);
            level.setBlock(blockpos.above(2), (BlockState)((BlockState)((Block)RisusBlocks.ASHEN_SPIRE.get()).defaultBlockState().setValue(AshenSpireBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)AshenSpireBlock.FLIPPED, (Comparable)(level.getBlockState(blockpos.above()).getBlock().defaultBlockState().is(RisusBlocks.ASHEN_SPIRE) ? (Boolean)level.getBlockState(blockpos.above()).getValue((Property)AshenSpireBlock.FLIPPED) : Boolean.valueOf(false))), 3);
            ServerParticleUtils.spawnParticleInBlock((LevelAccessor)level, blockpos.above(2), 3, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)RisusBlocks.ASHEN_SPIRE.get()).defaultBlockState()));
            level.playSound(null, blockpos.above(), SoundEvents.CAVE_VINES_PLACE, SoundSource.BLOCKS);
        }
        for (i = 0; i < 16; ++i) {
            BlockPos dPos = this.randomOffset(rand, pos, range, range + 5, range);
            if (level.getBiome(dPos) == biome) continue;
            int minY = QuartPos.fromBlock((int)level.getMinBuildHeight());
            int maxY = minY + QuartPos.fromBlock((int)level.getHeight()) - 1;
            int x = QuartPos.fromBlock((int)dPos.getX());
            int z = QuartPos.fromBlock((int)dPos.getZ());
            int y = QuartPos.fromBlock((int)dPos.getY());
            LevelChunk chunkAt = level.getChunk(dPos.getX() >> 4, dPos.getZ() >> 4);
            int u = QuartPos.fromBlock((int)chunkAt.getMinBuildHeight());
            int k = u + QuartPos.fromBlock((int)chunkAt.getHeight()) - 1;
            int l = Mth.clamp((int)QuartPos.fromBlock((int)dPos.getY()), (int)u, (int)k);
            int j = chunkAt.getSectionIndex(QuartPos.toBlock((int)l));
            LevelChunkSection section = chunkAt.getSection(j);
            for (int sy = 0; sy < 16; sy += 4) {
                PalettedContainerRO palettedContainerRO;
                if (section.getBiomes().get(x & 3, y & 3, z & 3) == biome || !((palettedContainerRO = section.getBiomes()) instanceof PalettedContainer)) continue;
                PalettedContainer container = (PalettedContainer)palettedContainerRO;
                container.set(x & 3, y & 3, z & 3, (Object)biome);
            }
            if (!chunkAt.isUnsaved()) {
                chunkAt.setUnsaved(true);
            }
            level.getChunkSource().chunkMap.resendBiomesForChunks(List.of(chunkAt));
        }
    }

    public BlockPos randomOffset(RandomSource random, BlockPos pos, int rx, int ry, int rz) {
        int dx = random.nextInt(rx * 2 + 1) - rx;
        int dy = random.nextInt(ry * 2 + 1) - ry;
        int dz = random.nextInt(rz * 2 + 1) - rz;
        return pos.offset(dx, dy, dz);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BiomeBlockEntity(pos, state);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)DirectionalBlock.FACING);
        BlockPos restingPos = pos.relative(facing.getOpposite());
        return BiomeBlock.canSupportCenter((LevelReader)world, (BlockPos)restingPos, (Direction)facing);
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)SPREADING)).booleanValue() || ((Boolean)pState.getValue((Property)SPREADING_MORK)).booleanValue() || ((Boolean)pState.getValue((Property)SPREADING_FEIGR)).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                double d0 = (double)pPos.getX() + pRandom.nextDouble();
                double d1 = (double)pPos.getY() + pRandom.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pPos.getZ() + pRandom.nextDouble();
                pLevel.addParticle((ParticleOptions)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), d0, d1, d2, 0.0, 0.0, 0.0);
            }
            pLevel.scheduleTick(pPos, (Block)this, 10);
        }
    }

    protected void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            boolean flag;
            boolean bl = flag = (Boolean)pState.getValue((Property)SPREADING) != false || (Boolean)pState.getValue((Property)SPREADING_FEIGR) != false || (Boolean)pState.getValue((Property)SPREADING_MORK) != false;
            if (flag != pLevel.hasNeighborSignal(pPos)) {
                pLevel.scheduleTick(pPos, (Block)this, 4);
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.IGNORE;
    }
}

