/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.init.RisusParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class ModdedWallTorchBlock
extends WallTorchBlock
implements SimpleMultiloggedBlock {
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;

    public ModdedWallTorchBlock(BlockBehaviour.Properties properties) {
        super(ParticleTypes.FLAME, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FLUIDLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockstate = this.defaultBlockState();
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())));
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.7;
        double d2 = (double)pos.getZ() + 0.5;
        Direction direction1 = direction.getOpposite();
        level.addParticle((ParticleOptions)RisusParticles.FIERY_ORGANIC_PARTICLE.get(), d0 + 0.27 * (double)direction1.getStepX(), d1 + 0.22, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)RisusParticles.JOYFLAME.get(), d0 + 0.27 * (double)direction1.getStepX(), d1 + 0.22, d2 + 0.27 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
    }
}

