/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.bigdious.risus.blocks.plantblocks.RisusGrowingPlantHeadBlock;
import com.bigdious.risus.init.RisusBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;

public class NeuronHeadBlock
extends RisusGrowingPlantHeadBlock
implements SimpleMultiloggedBlock {
    public static final MapCodec<NeuronHeadBlock> CODEC = NeuronHeadBlock.simpleCodec(NeuronHeadBlock::new);
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);

    public NeuronHeadBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, SHAPE, true, 0.05);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    protected MapCodec<NeuronHeadBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FLUIDLOGGED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType())))).setValue((Property)AGE, (Comparable)Integer.valueOf(context.getLevel().getRandom().nextInt(25)));
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (direction == this.growthDirection.getOpposite() && !state.canSurvive((LevelReader)accessor, pos)) {
            accessor.scheduleTick(pos, (Block)this, 1);
        }
        if (direction != this.growthDirection || !neighborState.is((Block)this) && !neighborState.is(this.getBodyBlock())) {
            if (this.scheduleFluidTicks && state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
                accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
            }
            return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
        }
        return this.updateBodyAfterConvertedFromHead(state, (BlockState)this.getBodyBlock().defaultBlockState().setValue(FLUIDLOGGED, (Comparable)((Object)((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))))));
    }

    @Override
    protected Block getBodyBlock() {
        return (Block)RisusBlocks.NEURON_STEM.get();
    }

    @Override
    protected int getBlocksToGrowWhenOrganicMattered(RandomSource pRandom) {
        return 1;
    }

    @Override
    protected boolean canGrowInto(BlockState state) {
        return state.isAir() || state.getBlock() == Blocks.WATER || state.getBlock() == Blocks.LAVA || state.getBlock() == RisusBlocks.BLOOD_FLUID_BLOCK.get();
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (stack.canPerformAction(ItemAbilities.SHEARS_HARVEST) && (Integer)state.getValue((Property)AGE) < 25) {
            level.setBlock(pos, (BlockState)((RisusGrowingPlantHeadBlock)RisusBlocks.NEURON_HEAD.get()).defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(25)), 2);
            level.playSound(player, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    @Override
    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((Integer)pState.getValue((Property)AGE) < 25 && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos.relative(this.growthDirection), (BlockState)pState, (pRandom.nextDouble() < 0.05 ? 1 : 0) != 0)) {
            BlockPos blockpos = pPos.relative(this.growthDirection);
            Block neighborFluid = pLevel.getBlockState(blockpos).getBlock();
            if (this.canGrowInto(pLevel.getBlockState(blockpos))) {
                pLevel.setBlockAndUpdate(blockpos, this.getGrowIntoState((BlockState)pState.setValue(FLUIDLOGGED, (Comparable)((Object)(neighborFluid == Blocks.WATER ? SimpleMultiloggedBlock.MultiloggingEnum.WATER : (neighborFluid == Blocks.LAVA ? SimpleMultiloggedBlock.MultiloggingEnum.LAVA : (neighborFluid == RisusBlocks.BLOOD_FLUID_BLOCK.get() ? SimpleMultiloggedBlock.MultiloggingEnum.BLOOD : SimpleMultiloggedBlock.MultiloggingEnum.EMPTY))))), pLevel.random));
                CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)blockpos, (BlockState)pLevel.getBlockState(blockpos));
            }
        }
    }

    @Override
    public void performOrganicMatter(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlockPos blockpos = pPos.relative(this.growthDirection);
        Block neighborFluid = pLevel.getBlockState(blockpos).getBlock();
        int i = Math.min((Integer)pState.getValue((Property)AGE) + 1, 25);
        int j = this.getBlocksToGrowWhenOrganicMattered(pRandom);
        for (int k = 0; k < j && this.canGrowInto(pLevel.getBlockState(blockpos)); ++k) {
            pLevel.setBlockAndUpdate(blockpos, (BlockState)((BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue(FLUIDLOGGED, (Comparable)((Object)(neighborFluid == Blocks.WATER ? SimpleMultiloggedBlock.MultiloggingEnum.WATER : (neighborFluid == Blocks.LAVA ? SimpleMultiloggedBlock.MultiloggingEnum.LAVA : (neighborFluid == RisusBlocks.BLOOD_FLUID_BLOCK.get() ? SimpleMultiloggedBlock.MultiloggingEnum.BLOOD : SimpleMultiloggedBlock.MultiloggingEnum.EMPTY))))));
            blockpos = blockpos.relative(this.growthDirection);
            i = Math.min(i + 1, 25);
        }
    }
}

