/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks;

import com.bigdious.risus.blocks.BaseRotatableBlock;
import com.bigdious.risus.blocks.interfaces.SimpleMultiloggedBlock;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RibcageBlock
extends BaseRotatableBlock
implements SimpleMultiloggedBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final EnumProperty<SimpleMultiloggedBlock.MultiloggingEnum> FLUIDLOGGED = SimpleMultiloggedBlock.MultiloggingEnum.FLUIDLOGGED;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)16.0, (double)14.5), (Object)Direction.SOUTH, (Object)Block.box((double)2.0, (double)0.0, (double)1.5, (double)14.0, (double)16.0, (double)11.0), (Object)Direction.WEST, (Object)Block.box((double)5.0, (double)0.0, (double)2.0, (double)14.5, (double)16.0, (double)14.0), (Object)Direction.EAST, (Object)Block.box((double)1.5, (double)0.0, (double)2.0, (double)11.0, (double)16.0, (double)14.0)));

    public RibcageBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.EMPTY)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF, FLUIDLOGGED});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        if (level.getBlockState(blockpos.below()).canBeReplaced() && blockpos.getY() > level.getMinBuildHeight() + 1) {
            return level.getBlockState(blockpos.above()).isSolidRender((BlockGetter)pContext.getLevel(), blockpos.above()) ? (BlockState)((BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType()))) : null;
        }
        if (level.getBlockState(blockpos.above()).canBeReplaced() && blockpos.getY() < level.getMaxBuildHeight() - 1) {
            return level.getBlockState(blockpos.above().above()).isSolidRender((BlockGetter)pContext.getLevel(), blockpos.above().above()) ? (BlockState)((BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(fluidstate.getType()))) : null;
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().defaultFluidState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (state.getValue(FLUIDLOGGED) != SimpleMultiloggedBlock.MultiloggingEnum.EMPTY) {
            accessor.scheduleTick(pos, ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid(), ((SimpleMultiloggedBlock.MultiloggingEnum)((Object)state.getValue(FLUIDLOGGED))).getFluid().getTickDelay((LevelReader)accessor));
        }
        if (direction.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == Direction.UP) || neighborState.is((Block)this) && neighborState.getValue(HALF) != half) {
            return half == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.LOWER) {
            BlockPos blockpos = pos.above();
            return reader.getBlockState(blockpos).isSolidRender((BlockGetter)reader, pos.above());
        }
        BlockState blockstate = reader.getBlockState(pos.above());
        return blockstate.is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.UPPER;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        boolean top = state.getValue(HALF) == DoubleBlockHalf.UPPER;
        BlockPos blockpos = top ? pos.below() : pos.above();
        level.setBlock(blockpos, RibcageBlock.copyFluidLoggingFrom((LevelReader)level, blockpos, (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)(top ? DoubleBlockHalf.LOWER : DoubleBlockHalf.UPPER))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))), 3);
    }

    public static BlockState copyFluidLoggingFrom(LevelReader reader, BlockPos pos, BlockState state) {
        return state.hasProperty(FLUIDLOGGED) ? (BlockState)state.setValue(FLUIDLOGGED, (Comparable)((Object)SimpleMultiloggedBlock.MultiloggingEnum.getFromFluid(reader.getFluidState(pos).getType()))) : state;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide()) {
            if (player.isCreative()) {
                RibcageBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
            } else {
                RibcageBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockstate.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockpos, blockstate1, 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABBS.get(state.getValue((Property)FACING));
    }
}

