/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.entity;

import com.bigdious.risus.entity.Weaver;
import com.bigdious.risus.init.RisusBlockEntities;
import com.bigdious.risus.init.RisusEntities;
import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class WeaverNestBlockEntity
extends BlockEntity
implements IOwnedSpawner {
    private static final int DELAY = 1200;
    private static final int MAX_NEARBY = 10;
    private static final int PLAYER_RANGE = 32;
    private static final int SPAWN_RANGE = 10;
    private int spawnDelay;

    public WeaverNestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RisusBlockEntities.WEAVER_NEST.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WeaverNestBlockEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.isNearPlayer(level, pos) && level.getDifficulty() != Difficulty.PEACEFUL) {
                if (entity.spawnDelay == -1) {
                    entity.spawnDelay = 1200;
                }
                if (entity.spawnDelay > 0) {
                    --entity.spawnDelay;
                } else {
                    int k = level.getEntities(EntityTypeTest.forExactClass(Weaver.class), new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate(10.0), EntitySelector.NO_SPECTATORS).size();
                    if (k >= 10) {
                        entity.spawnDelay = 1200;
                        return;
                    }
                    Weaver weaver = (Weaver)((EntityType)RisusEntities.WEAVER.get()).create(level);
                    weaver.moveTo(pos.getBottomCenter(), 0.0f, 0.0f);
                    EventHooks.finalizeMobSpawnSpawner((Mob)weaver, (ServerLevelAccessor)serverLevel, (DifficultyInstance)level.getCurrentDifficultyAt(weaver.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)entity, (boolean)true);
                    if (!level.addFreshEntity((Entity)weaver)) {
                        entity.spawnDelay = 1200;
                        return;
                    }
                    level.gameEvent((Entity)weaver, (Holder)GameEvent.ENTITY_PLACE, pos);
                    weaver.spawnAnim();
                    entity.spawnDelay = 1200;
                }
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putShort("Delay", (short)this.spawnDelay);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.spawnDelay = tag.getShort("Delay");
    }

    private boolean isNearPlayer(Level level, BlockPos pos) {
        return level.hasNearbyAlivePlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 32.0);
    }

    @Nullable
    public Either<BlockEntity, Entity> getOwner() {
        return Either.left((Object)((Object)this));
    }
}

