/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.fluid;

import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public class BloodFluid
extends BaseFlowingFluid {
    protected BloodFluid(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return (ParticleOptions)RisusParticles.DRIPPING_BLOOD.get();
    }

    public boolean isSource(FluidState pState) {
        return false;
    }

    public int getAmount(FluidState pState) {
        return 6;
    }

    protected boolean canConvertToSource(Level pLevel) {
        return true;
    }

    protected void randomTick(Level world, BlockPos pos, FluidState state, RandomSource random) {
        super.randomTick(world, pos, state, random);
    }

    public void tick(Level worldIn, BlockPos pos, FluidState state) {
        super.tick(worldIn, pos, state);
    }

    public int getTickDelay(LevelReader p_205569_1_) {
        return 5;
    }

    public static class Source
    extends BloodFluid {
        public Source(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        @Override
        public int getAmount(FluidState state) {
            return 8;
        }

        @Override
        public boolean isSource(FluidState state) {
            return true;
        }

        protected boolean isRandomlyTicking() {
            return true;
        }

        public void animateTick(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
            if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
                if (random.nextInt(64) == 0) {
                    worldIn.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, RisusSoundEvents.BLOOD_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f);
                }
            } else if (random.nextInt(14) == 0) {
                if (random.nextInt(2) == 0) {
                    worldIn.addParticle((ParticleOptions)RisusParticles.BLOOD.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), -0.01 + random.nextDouble() * 0.02, -0.01 + random.nextDouble() * 0.02, -0.01 + random.nextDouble() * 0.02);
                }
                worldIn.addParticle((ParticleOptions)RisusParticles.BLOOD_BIT.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), -0.01 + random.nextDouble() * 0.02, -0.01 + random.nextDouble() * 0.02, -0.01 + random.nextDouble() * 0.02);
            }
        }
    }

    public static class Flowing
    extends BloodFluid {
        public Flowing(BaseFlowingFluid.Properties properties) {
            super(properties);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected boolean isRandomlyTicking() {
            return true;
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        @Override
        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
            if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
                if (random.nextInt(64) == 0) {
                    level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, RisusSoundEvents.BLOOD_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f);
                }
            } else if (random.nextInt(12) == 0) {
                if (random.nextInt(3) == 0) {
                    level.addParticle((ParticleOptions)RisusParticles.BLOOD.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble() * (double)((Integer)state.getValue((Property)LEVEL) / 8), (double)pos.getZ() + random.nextDouble(), -0.01 + random.nextDouble() * 0.02, -0.02 + random.nextDouble() * 0.02, -0.01 + random.nextDouble() * 0.02);
                }
                level.addParticle((ParticleOptions)RisusParticles.BLOOD_BIT.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble() * (double)((Integer)state.getValue((Property)LEVEL) / 8), (double)pos.getZ() + random.nextDouble(), -0.01 + random.nextDouble() * 0.02, -0.01 + random.nextDouble() * 0.02, -0.01 + random.nextDouble() * 0.02);
            }
        }
    }
}

